% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_SNV.R
\name{findSNVs}
\alias{findSNVs}
\title{Find the window of SNVs at a focal point}
\usage{
findSNVs(hapMat, focalSNV, minWindow = 1)
}
\arguments{
\item{hapMat}{\code{hapMat} data object.}

\item{focalSNV}{The column number of the focal in the haplotype data matrix
at which to reconstruct the dendrogram.}

\item{minWindow}{Minimum window size of the SNV neighborhood.}
}
\value{
Return a list of SNVs in the window with their state of compatiblity to \code{\link{selectWindow}}.
}
\description{
This function identifies a window of compatible SNVs about the focal SNV.
}
\details{
This function starts at the focal SNV, and tries expanding the neighborhood of compatible SNVs.
This process is stopped when there are no more compatible SNVs to the left or right
of the focal SNV. If the block of compatible SNVs does not have at least a user-defined minimum number
of SNVs, this function expands the window to include incompatible SNVs.
}
\examples{

\dontshow{
data(ex_hapMatSmall_data)

# Compatible SNVs about the focal SNV

compSNVs <- findSNVs(hapMat = ex_hapMatSmall_data, focalSNV = 10, minWindow = 1)

}                                         

}
\seealso{
\code{\link{selectWindow}}, \code{\link{checkCompatible}}, \code{\link{getnSNVs}},
         \code{\link{getNextFromFocal}}, \code{\link{getNextLeftFocal}}, \code{\link{getNextRightFocal}}
}
\keyword{internal}
