% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel_test.R
\name{MantelTest}
\alias{MantelTest}
\title{Mantel test for association of two distance matirces}
\usage{
MantelTest(Dx, Dy, nperm)
}
\arguments{
\item{Dx}{A numeric matrix of pairwise distances.}

\item{Dy}{A second numeric matrix of pairwise distances.}

\item{nperm}{The number of times to permute the rows and columns of \code{Dy}.}
}
\value{
A list contains Mantel statistic and permutation P value.
}
\description{
This function performs Mantel test for correlation between two distance matrices. It 
computes P value by randomly permuting rows and columns of the second matrix.
}
\examples{

x <- runif(8)
y <- runif(8)
# Distance matrices
distX = as.matrix(dist(x, upper = TRUE, diag = TRUE))
distY = as.matrix(dist(y, upper = TRUE, diag = TRUE))

MantelTest(Dx = distX, Dy = distY, nperm = 1000)


}
\references{
Mantel, N. (1967) The detection of disease clustering and a generalized
            regression approach. Cancer Research, 27, 209 - 220.
}
