% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals-methods.R
\name{residuals.pense_fit}
\alias{residuals.pense_fit}
\title{Extract Residuals}
\usage{
\method{residuals}{pense_fit}(object, lambda, exact = deprecated(), correction = deprecated(), ...)
}
\arguments{
\item{object}{PENSE regularization path to extract residuals from.}

\item{lambda}{a single value of the penalty parameter.}

\item{exact}{defunct Always gives a warning if \code{lambda} is not part of the fitted sequence and coefficients
need to be interpolated.}

\item{correction}{defunct.}

\item{...}{currently not used.}
}
\value{
a numeric vector of residuals for the given penalization level.
}
\description{
Extract residuals from a PENSE (or LS-EN) regularization path fitted by \code{\link[=pense]{pense()}} or \code{\link[=elnet]{elnet()}}.
}
\examples{
# Compute the LS-EN regularization path for Freeny's revenue data
# (see ?freeny)
data(freeny)
x <- as.matrix(freeny[ , 2:5])

regpath <- elnet(x, freeny$y, alpha = 0.75)

# Predict the response using a specific penalization level
predict(regpath, newdata = freeny[1:5, 2:5],
        lambda = regpath$lambda[10])

# Extract the residuals at a certain penalization level
residuals(regpath, lambda = regpath$lambda[5])

# Select penalization level via cross-validation
cv_results <- elnet_cv(x, freeny$y, alpha = 0.5, cv_repl = 10,
                       cv_k = 4)

# Predict the response using the "best" penalization level
predict(cv_results, newdata = freeny[1:5, 2:5])

# Extract the residuals at the "best" penalization level
residuals(cv_results)^2
# Extract the residuals at a more parsimonious penalization level
residuals(cv_results, lambda = 'se')
}
\seealso{
Other functions for extracting components: 
\code{\link{coef.pense_cvfit}()},
\code{\link{coef.pense_fit}()},
\code{\link{predict.pense_cvfit}()},
\code{\link{predict.pense_fit}()},
\code{\link{residuals.pense_cvfit}()}
}
\concept{functions for extracting components}
