% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_internal.R
\name{internalplot}
\alias{internalplot}
\alias{.pedAlignment}
\alias{.pedAnnotation}
\alias{.pedScaling}
\alias{.drawPed}
\alias{.annotatePed}
\title{Internal plot methods}
\usage{
.pedAlignment(
  x = NULL,
  plist = NULL,
  arrows = FALSE,
  twins = NULL,
  packed = TRUE,
  width = 10,
  align = c(1.5, 2),
  hints = NULL,
  ...
)

.pedAnnotation(
  x,
  title = NULL,
  marker = NULL,
  sep = "/",
  missing = "-",
  showEmpty = FALSE,
  labs = labels(x),
  foldLabs = 12,
  trimLabs = TRUE,
  col = 1,
  fill = NA,
  lty = 1,
  lwd = 1,
  hatched = NULL,
  hatchDensity = 25,
  aff = NULL,
  carrier = NULL,
  deceased = NULL,
  starred = NULL,
  textAnnot = NULL,
  textInside = NULL,
  textAbove = NULL,
  fouInb = "autosomal",
  ...
)

.pedScaling(
  alignment,
  annotation,
  cex = 1,
  symbolsize = 1,
  margins = 1,
  addSpace = 0,
  xlim = NULL,
  ylim = NULL,
  vsep2 = FALSE,
  autoScale = FALSE,
  minsize = 0.15,
  ...
)

.drawPed(alignment, annotation, scaling)

.annotatePed(
  alignment,
  annotation,
  scaling,
  font = NULL,
  fam = NULL,
  col = NULL,
  colUnder = 1,
  colInside = 1,
  colAbove = 1,
  cex.main = NULL,
  font.main = NULL,
  col.main = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object.}

\item{plist}{Alignment list with format similar to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}.}

\item{arrows}{A logical (default = FALSE). If TRUE, the pedigree is plotted
as a DAG, i.e., with arrows connecting parent-child pairs.}

\item{twins}{A data frame with columns \code{id1}, \code{id2} and \code{code}, passed on to
the \code{relation} parameter of \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.}

\item{packed, width, align}{Parameters passed on to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}. Can usually be left untouched.}

\item{hints}{An optional list of hints passed on to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}.}

\item{\dots}{Further parameters passed between methods.}

\item{title}{The plot title. If NULL (default) or '', no title is added to
the plot.}

\item{marker}{Either a vector of names or indices referring to markers
attached to \code{x}, a \code{marker} object, or a list of such. The genotypes for
the chosen markers are written below each individual in the pedigree, in
the format determined by \code{sep} and \code{missing}. See also \code{showEmpty}. If NULL
(the default), no genotypes are plotted.}

\item{sep}{A character of length 1 separating alleles for diploid markers.}

\item{missing}{The symbol (integer or character) for missing alleles.}

\item{showEmpty}{A logical, indicating if empty genotypes should be included.}

\item{labs}{A vector or function controlling the individual labels in the
plot. By default, \code{labels(x)} are used. See Details for valid formats.}

\item{foldLabs}{A number or function controlling the folding of long labels.
If a number, line breaks are inserted at roughly this width, trying to
break at break-friendly characters. If a function, this is applied to each
label.}

\item{trimLabs}{A logical, by default TRUE. Removes line breaks and tabs from
both ends of the labels (after adding genotypes, if \code{marker} is not NULL).}

\item{col}{A vector or list specifying outline colours for the pedigree
members. See Details for valid formats.}

\item{fill}{A vector or list specifying fill/hatch colours for the pedigree
members. See Details for valid formats. Note that if \code{fill} is unnamed, and
either \code{aff} or \code{hatched} are given, then the fill colour is applied only
to those.}

\item{lty, lwd}{Vectors or lists specifying linetype and width of pedigree
symbol outlines. See Details for valid formats.}

\item{hatched}{A vector of labels identifying members whose plot symbols
should be hatched.}

\item{hatchDensity}{A number specifying the hatch density in lines per inch.
Default: 25.}

\item{aff}{A vector of labels identifying members whose plot symbols should
be filled. (This is typically used in medical pedigrees to indicate
affected members.)}

\item{carrier}{A vector of labels identifying members whose plot symbols
should be marked with a dot. (This is typically used in medical pedigrees
to indicate unaffected carriers of the disease allele.)}

\item{deceased}{A vector of labels indicating deceased pedigree members.}

\item{starred}{A vector of labels indicating pedigree members that should be
marked with a star in the pedigree plot.}

\item{textAnnot}{A list specifying further text annotation around or inside
the pedigree symbols. See Details for more information.}

\item{textInside, textAbove}{Character vectors of text to be printed inside or
above pedigree symbols. [Soft deprecated; replaced by \code{textAnnot}.]}

\item{fouInb}{Either "autosomal" (default), "x" or NULL. If "autosomal" or
"x", inbreeding coefficients are added to the plot above the inbred
founders. If NULL, or if no founders are inbred, nothing is added.}

\item{alignment}{List of alignment details, as returned by \code{\link[=.pedAlignment]{.pedAlignment()}}.}

\item{annotation}{List of annotation details as returned by
\code{\link[=.pedAnnotation]{.pedAnnotation()}}.}

\item{cex}{Expansion factor controlling font size. This also affects symbol
sizes, which by default have the width of 2.5 characters. Default: 1.}

\item{symbolsize}{Expansion factor for pedigree symbols. Default: 1.}

\item{margins}{A numeric indicating the plot margins. If a single number is
given, it is recycled to length 4.}

\item{addSpace}{A numeric of length 4, indicating extra padding (in inches)
around the pedigree inside the plot region. Default: 0.}

\item{xlim, ylim}{Numeric vectors of length 2, used to set \code{par("usr")}
explicitly. Rarely needed by end users.}

\item{vsep2}{A logical; for internal use.}

\item{autoScale}{A logical. It TRUE, an attempt is made to adjust \code{cex} so
that the symbol dimensions are at least \code{minsize} inches. Default: FALSE.}

\item{minsize}{A positive number, by default 0.15. (See \code{autoScale}.)}

\item{scaling}{List of scaling parameters as returned by \code{\link[=.pedScaling]{.pedScaling()}}.}

\item{font, fam}{Arguments passed on to \code{\link[=text]{text()}}.}

\item{colUnder, colInside, colAbove}{Colour vectors.}

\item{cex.main, col.main, font.main}{Parameters passed on to \code{\link[=title]{title()}}.}
}
\description{
The main purpose of this page is to document the many options for pedigree
plotting. Most of the arguments shown here may be supplied directly in
\code{plot(x, ...)}, where \code{x} is a pedigree. See \code{\link[=plot.ped]{plot.ped()}} for many examples.
}
\details{
The workflow of \code{plot.ped(x, ...)} is approximately as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{
# Calculate plot parameters

align = .pedAlignment(x, ...)

annot = .pedAnnotation(x, ...)

scale = .pedScaling(align, annot, ...)

# Produce plot

.drawPed(align, annot, scale)

.annotatePed(align, annot, scale)

}\if{html}{\out{</div>}}

The \code{labs} argument control the individual ID labels printed below the
pedigree symbols. By default the output of \code{labels(x)} is used, but there are
several alternative forms:
\itemize{
\item If \code{labs} is a vector with nonempty intersection with \code{labels(x)}, only
these individuals will be labelled. If the vector is named, then the names
are used instead of the ID label. (See Examples.)
\item If \code{labs} is the word "num", then all individuals are numerically
labelled following the internal ordering.
\item Use \code{labs = NULL} to remove all labels.
\item If \code{labs} is a function, it is replaced with \code{labs(x)} and handled as
above. (See Examples.)
}

The argument \code{textAnnot} allows customised annotation around and inside each
symbol. This takes a list of lists, whose names may include "topleft",
"topright", "left", "right", "bottomleft", "bottom", "bottomright" and
"inside". Each inner list should contain a character vector as its first
element (with the text to printed), followed by further arguments passed to
\code{\link[=text]{text()}}. For example, \code{textAnnot = list(left = list(c(A = "1"), cex = 2))}
prints a large number "1" to the left of individual A (if such an individual
exists in the pedigree. See Examples.

The arguments \code{col}, \code{fill}, \code{lty} and \code{lwd} can all be indicated in a number
of ways:
\itemize{
\item An unnamed vector. This will be recycled and applied to all members. For
example, \code{lty = 2} gives everyone a dashed outline.
\item A named vector. Only pedigree members appearing in the names are affected.
Example: \code{fill = c("1" = "red", foo = "blue")} fills individual \code{1} red and
\code{foo} blue.
\item A list of ID vectors, where the list names indicate the parameter values.
Example: \code{col = list(red = 1:2, blue = 3:5)}.
\item List entries may also be functions, taking the pedigree \code{x} as input and
producing a vector of ID labels. The many built-in functions in
\link{ped_subgroups} are particularly handy here, e.g.: \code{fill = list(red = founders, blue = leaves)}.
}
}
\examples{
x = nuclearPed()

align = .pedAlignment(x)
annot = .pedAnnotation(x)
scale = .pedScaling(align, annot)

frame()
drawPed(align, annot, scale)

}
