% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_sort.R
\name{sortGenotypes}
\alias{sortGenotypes}
\title{Sort the alleles in each genotype}
\usage{
sortGenotypes(x)
}
\arguments{
\item{x}{A \code{ped} object or a list of such}
}
\value{
An object identical to \code{x} except that the all genotypes are sorted.
}
\description{
Ensure that all genotypes are sorted internally. For example, if a marker
attached to \code{x} has alleles 1 and 2, then running this function will replace
all genotypes "2/1" by "1/2".
}
\examples{
x = singleton(1)

# Various markers with misordered genotypes
m1 = marker(x, `1` = 2:1)
m2 = marker(x, `1` = c('b','a'))
m3 = marker(x, `1` = c("100.3", "99.1"))
x = setMarkers(x, list(m1, m2, m3))
x

# Sort all genotypes
y = sortGenotypes(x)
y

# Also works when input is a list of peds
sortGenotypes(list(x, x))

}
