% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvndst}
\alias{mvndst}
\title{Multivariate Normal Distribution CDF}
\usage{
mvndst(
  lower,
  upper,
  mu,
  sigma,
  maxvls = 25000L,
  abs_eps = 0.001,
  rel_eps = 0L,
  minvls = -1L,
  do_reorder = TRUE,
  use_aprx = FALSE,
  method = 0L,
  n_sequences = 8L
)
}
\arguments{
\item{lower}{numeric vector with lower bounds.}

\item{upper}{numeric vector with upper bounds.}

\item{mu}{numeric vector with means.}

\item{sigma}{covariance matrix.}

\item{maxvls}{maximum number of samples in the approximation.}

\item{abs_eps}{absolute convergence threshold.}

\item{rel_eps}{relative convergence threshold.}

\item{minvls}{minimum number of samples. Negative values provides a
default which depends on the dimension of the integration.}

\item{do_reorder}{\code{TRUE} if a heuristic variable reordering should
be used. \code{TRUE} is likely the best value.}

\item{use_aprx}{\code{TRUE} if a less precise approximation of
\code{\link{pnorm}} and \code{\link{qnorm}} should be used. This may
reduce the computation time while not affecting the result much.}

\item{method}{integer with the method to use. Zero yields randomized Korobov
lattice rules while one yields scrambled Sobol sequences.}

\item{n_sequences}{number of randomized quasi-Monte Carlo sequences to use.
More samples yields a better estimate of the error but a worse
approximation. Eight is used in the original Fortran code. If one is
used then the error will be set to zero because it cannot be estimated.}
}
\value{
An approximation of the CDF. The \code{"n_it"} attribute shows the number of
integrand evaluations, the \code{"inform"} attribute is zero if the
requested precision is achieved, and the \code{"abserr"} attribute
shows 3.5 times the estimated standard error.
}
\description{
Provides an approximation of the multivariate normal distribution CDF
over a hyperrectangle.
}
\examples{
# simulate covariance matrix and the upper bound
set.seed(1)
n <- 10L
S <- drop(rWishart(1L, 2 * n, diag(n) / 2 / n))
u <- rnorm(n)

system.time(pedmod_res <- mvndst(
  lower = rep(-Inf, n), upper = u, sigma = S, mu = numeric(n),
  maxvls = 1e6, abs_eps = 0, rel_eps = 1e-4, use_aprx = TRUE))
pedmod_res

# compare with mvtnorm
if(require(mvtnorm)){
  mvtnorm_time <- system.time(mvtnorm_res <- pmvnorm(
    upper = u, sigma = S, algorithm = GenzBretz(
      maxpts = 1e6, abseps = 0, releps = 1e-4)))
  cat("mvtnorm_res:\n")
  print(mvtnorm_res)

  cat("mvtnorm_time:\n")
  print(mvtnorm_time)
}

}
