% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Expm}
\alias{Expm}
\title{Riemannian HPD exponential map}
\usage{
Expm(P, H)
}
\arguments{
\item{P}{a Hermitian positive definite matrix.}

\item{H}{a Hermitian matrix (of equal dimension as \code{P}).}
}
\description{
\code{Expm(P, H)} computes the projection of a Hermitian matrix \code{H} from the tangent space at a Hermitian
PD matrix \code{P} to the manifold of Hermitian PD matrices equipped with the affine-invariant Riemannian metric
via the exponential map as in e.g., \insertCite{PFA05}{pdSpecEst}. This is the unique inverse of the Riemannian
logarithmic map \code{\link{Logm}}.
}
\examples{
 ## Generate random Hermitian matrix
 H <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 diag(H) <- rnorm(3)
 H[lower.tri(H)] <- t(Conj(H))[lower.tri(H)]
 ## Generate random HPD matrix
 p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 P <- t(Conj(p)) \%*\% p
 ## Compute exponential map
 Expm(P, H)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Logm}, \link{pdParTrans}}
}
