% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{plotPEedges}
\alias{plotPEedges}
\title{The plot of the edges of the underlying or reflexivity graph of
the Proportional Edge Proximity Catch Digraph
(PE-PCD) for 2D data - multiple triangle case}
\usage{
plotPEedges(
  Xp,
  Yp,
  r,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity"),
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the PE-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay
triangle or circumcenter of each Delaunay triangle
(for this, argument should be set as \code{M="CC"}),
default for \eqn{M=(1,1,1)}
which is the center of mass of each triangle.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}

\item{asp}{A \code{numeric} value,
giving the aspect ratio \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes,
respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2,
giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the edges of the underlying
or reflexivity graphs of the PE-PCD
whose vertices are the points in data set \code{Xp} and the Delaunay
triangles based on \code{Yp} points
}
\description{
Plots the edges of the underlying or reflexivity graph of
the Proportional Edge Proximity Catch Digraph
(PE-PCD) whose vertices are the data
points in \code{Xp} in the multiple triangle case
and the Delaunay triangles based on \code{Yp} points.

PE proximity regions are constructed
with respect to the Delaunay triangles based on \code{Yp} points, i.e.,
PE proximity regions are defined only for \code{Xp} points
inside the convex hull of \code{Yp} points.
That is, edges may exist for \code{Xp} points
only inside the convex hull of \code{Yp} points.

Vertex regions in each triangle are
based on the center \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of each Delaunay triangle
or based on circumcenter of
each Delaunay triangle (default for \eqn{M=(1,1,1)}
which is the center of mass of the triangle).

Convex hull of \code{Yp} is partitioned by
the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
Loops are not allowed so edges are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the PE-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)
r<-1.5

plotPEedges(Xp,Yp,r,M,xlab="",ylab="")
plotPEedges(Xp,Yp,r,M,xlab="",ylab="",ugraph="r")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEedges.tri}}, \code{\link{plotASedges}},
\code{\link{plotCSedges}}, and \code{\link[pcds]{plotPEarcs}}
}
\author{
Elvan Ceyhan
}
