% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_update_policy}
\alias{verifiedpermissions_update_policy}
\title{Modifies a Cedar static policy in the specified policy store}
\usage{
verifiedpermissions_update_policy(policyStoreId, policyId, definition)
}
\arguments{
\item{policyStoreId}{[required] Specifies the ID of the policy store that contains the policy that you
want to update.}

\item{policyId}{[required] Specifies the ID of the policy that you want to update. To find this
value, you can use \code{\link[=verifiedpermissions_list_policies]{list_policies}}.}

\item{definition}{[required] Specifies the updated policy content that you want to replace on the
specified policy. The content must be valid Cedar policy language text.

You can change only the following elements from the policy definition:
\itemize{
\item The \code{action} referenced by the policy.
\item Any conditional clauses, such as \code{when} or \code{unless} clauses.
}

You \strong{can't} change the following elements:
\itemize{
\item Changing from \code{static} to \code{templateLinked}.
\item Changing the effect of the policy from \code{permit} or \code{forbid}.
\item The \code{principal} referenced by the policy.
\item The \code{resource} referenced by the policy.
}}
}
\description{
Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the \href{https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition}{UpdatePolicyDefinition} parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using \code{\link[=verifiedpermissions_update_policy_template]{update_policy_template}}.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy/} for full documentation.
}
\keyword{internal}
