% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_create_configuration_policy}
\alias{securityhub_create_configuration_policy}
\title{Creates a configuration policy with the defined configuration}
\usage{
securityhub_create_configuration_policy(
  Name,
  Description = NULL,
  ConfigurationPolicy,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the configuration policy. Alphanumeric characters and the
following ASCII characters are permitted: \verb{-, ., !, *, /}.}

\item{Description}{The description of the configuration policy.}

\item{ConfigurationPolicy}{[required] An object that defines how Security Hub is configured. It includes
whether Security Hub is enabled or disabled, a list of enabled security
standards, a list of enabled or disabled security controls, and a list
of custom parameter values for specified controls. If you provide a list
of security controls that are enabled in the configuration policy,
Security Hub disables all other controls (including newly released
controls). If you provide a list of security controls that are disabled
in the configuration policy, Security Hub enables all other controls
(including newly released controls).}

\item{Tags}{User-defined tags associated with a configuration policy. For more
information, see \href{https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html}{Tagging Security Hub resources}
in the \emph{Security Hub user guide}.}
}
\description{
Creates a configuration policy with the defined configuration. Only the Security Hub delegated administrator can invoke this operation from the home Region.

See \url{https://www.paws-r-sdk.com/docs/securityhub_create_configuration_policy/} for full documentation.
}
\keyword{internal}
