% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_retirable_grants}
\alias{kms_list_retirable_grants}
\title{Returns information about all grants in the Amazon Web Services account
and Region that have the specified retiring principal}
\usage{
kms_list_retirable_grants(Limit = NULL, Marker = NULL, RetiringPrincipal)
}
\arguments{
\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, KMS does not return more than the specified
number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
100, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}

\item{RetiringPrincipal}{[required] The retiring principal for which to list grants. Enter a principal in
your Amazon Web Services account.

To specify the retiring principal, use the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of an Amazon Web Services principal. Valid principals include Amazon Web
Services accounts, IAM users, IAM roles, federated users, and assumed
role users. For help with the ARN syntax for a principal, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns}{IAM ARNs}
in the \emph{Identity and Access Management User Guide} .}
}
\description{
Returns information about all grants in the Amazon Web Services account and Region that have the specified retiring principal.

See \url{https://www.paws-r-sdk.com/docs/kms_list_retirable_grants/} for full documentation.
}
\keyword{internal}
