% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_describe_key}
\alias{kms_describe_key}
\title{Provides detailed information about a KMS key}
\usage{
kms_describe_key(KeyId, GrantTokens = NULL)
}
\arguments{
\item{KeyId}{[required] Describes the specified KMS key.

If you specify a predefined Amazon Web Services alias (an Amazon Web
Services alias with no key ID), KMS associates the alias with an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk}{Amazon Web Services managed key}
and returns its \code{KeyId} and \code{Arn} in the response.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Provides detailed information about a KMS key. You can run \code{\link[=kms_describe_key]{describe_key}} on a \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed key} or an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{Amazon Web Services managed key}.

See \url{https://www.paws-r-sdk.com/docs/kms_describe_key/} for full documentation.
}
\keyword{internal}
