% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector2_operations.R
\name{inspector2_create_filter}
\alias{inspector2_create_filter}
\title{Creates a filter resource using specified filter criteria}
\usage{
inspector2_create_filter(
  action,
  description = NULL,
  filterCriteria,
  name,
  reason = NULL,
  tags = NULL
)
}
\arguments{
\item{action}{[required] Defines the action that is to be applied to the findings that match the
filter.}

\item{description}{A description of the filter.}

\item{filterCriteria}{[required] Defines the criteria to be used in the filter for querying findings.}

\item{name}{[required] The name of the filter. Minimum length of 3. Maximum length of 64. Valid
characters include alphanumeric characters, dot (.), underscore (_),
and dash (-). Spaces are not allowed.}

\item{reason}{The reason for creating the filter.}

\item{tags}{A list of tags for the filter.}
}
\description{
Creates a filter resource using specified filter criteria. When the filter action is set to \code{SUPPRESS} this action creates a suppression rule.

See \url{https://www.paws-r-sdk.com/docs/inspector2_create_filter/} for full documentation.
}
\keyword{internal}
