% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_attributes}
\alias{cognitoidentityprovider_update_user_attributes}
\title{With this operation, your users can update one or more of their
attributes with their own credentials}
\usage{
cognitoidentityprovider_update_user_attributes(
  UserAttributes,
  AccessToken,
  ClientMetadata = NULL
)
}
\arguments{
\item{UserAttributes}{[required] An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \verb{custom:} prefix to the
attribute name.

If you have set an attribute to require verification before Amazon
Cognito updates its value, this request doesn’t immediately update the
value of that attribute. After your user receives and responds to a
verification message to verify the new value, Amazon Cognito updates the
attribute value. Your user can sign in and receive messages with the
original attribute value until they verify the new value.}

\item{AccessToken}{[required] A valid access token that Amazon Cognito issued to the user whose user
attributes you want to update.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action initiates.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the UpdateUserAttributes API action, Amazon
Cognito invokes the function that is assigned to the \emph{custom message}
trigger. When Amazon Cognito invokes this function, it passes a JSON
payload, which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your UpdateUserAttributes request. In
your function code in Lambda, you can process the \code{clientMetadata} value
to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
With this operation, your users can update one or more of their attributes with their own credentials. You authorize this API request with the user's access token. To delete an attribute from your user, submit the attribute in your API request with a blank value. Custom attribute values in this request must include the \verb{custom:} prefix.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_attributes/} for full documentation.
}
\keyword{internal}
