% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_add_tags_to_certificate}
\alias{acm_add_tags_to_certificate}
\title{Adds one or more tags to an ACM certificate}
\usage{
acm_add_tags_to_certificate(CertificateArn, Tags)
}
\arguments{
\item{CertificateArn}{[required] String that contains the ARN of the ACM certificate to which the tag is
to be applied. This must be of the form:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}.}

\item{Tags}{[required] The key-value pair that defines the tag. The tag value is optional.}
}
\description{
Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a \code{key} and an optional \code{value}. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair.

See \url{https://www.paws-r-sdk.com/docs/acm_add_tags_to_certificate/} for full documentation.
}
\keyword{internal}
