# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Macie
#'
#' @description
#' Amazon Macie Classic
#' 
#' Amazon Macie Classic has been discontinued and is no longer available.
#' 
#' A new Amazon Macie is now available with significant design improvements
#' and additional features, at a lower price and in most Amazon Web
#' Services Regions. We encourage you to take advantage of the new and
#' improved features, and benefit from the reduced cost. To learn about
#' features and pricing for the new Macie, see [Amazon
#' Macie](https://aws.amazon.com/macie/). To learn how to use the new
#' Macie, see the [Amazon Macie User
#' Guide](https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- macie(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- macie()
#' svc$associate_member_account(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=macie_associate_member_account]{associate_member_account} \tab (Discontinued) Associates a specified Amazon Web Services account with Amazon Macie Classic as a member account\cr
#'  \link[=macie_associate_s3_resources]{associate_s3_resources} \tab (Discontinued) Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification\cr
#'  \link[=macie_disassociate_member_account]{disassociate_member_account} \tab (Discontinued) Removes the specified member account from Amazon Macie Classic\cr
#'  \link[=macie_disassociate_s3_resources]{disassociate_s3_resources} \tab (Discontinued) Removes specified S3 resources from being monitored by Amazon Macie Classic\cr
#'  \link[=macie_list_member_accounts]{list_member_accounts} \tab (Discontinued) Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account\cr
#'  \link[=macie_list_s3_resources]{list_s3_resources} \tab (Discontinued) Lists all the S3 resources associated with Amazon Macie Classic\cr
#'  \link[=macie_update_s3_resources]{update_s3_resources} \tab (Discontinued) Updates the classification types for the specified S3 resources
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname macie
#' @export
macie <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .macie$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.macie <- list()

.macie$operations <- list()

.macie$metadata <- list(
  service_name = "macie",
  endpoints = list("*" = list(endpoint = "macie.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "macie.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "macie.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "macie.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Macie",
  api_version = "2017-12-19",
  signing_name = "macie",
  json_version = "1.1",
  target_prefix = "MacieService"
)

.macie$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.macie$metadata, handlers, config)
}
