% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_web_acl}
\alias{wafregional_update_web_acl}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_update_web_acl(
  WebACLId,
  ChangeToken,
  Updates = NULL,
  DefaultAction = NULL
)
}
\arguments{
\item{WebACLId}{[required] The \code{WebACLId} of the WebACL that you want to update. \code{WebACLId} is
returned by \code{\link[=wafregional_create_web_acl]{create_web_acl}} and by
\code{\link[=wafregional_list_web_ac_ls]{list_web_ac_ls}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=wafregional_get_change_token]{get_change_token}}.}

\item{Updates}{An array of updates to make to the WebACL.

An array of \code{WebACLUpdate} objects that you want to insert into or
delete from a WebACL. For more information, see the applicable data
types:
\itemize{
\item WebACLUpdate: Contains \code{Action} and \code{ActivatedRule}
\item ActivatedRule: Contains \code{Action}, \code{OverrideAction}, \code{Priority},
\code{RuleId}, and \code{Type}. \code{ActivatedRule|OverrideAction} applies only
when updating or adding a \code{RuleGroup} to a \code{WebACL}. In this case,
you do not use \code{ActivatedRule|Action}. For all other update
requests, \code{ActivatedRule|Action} is used instead of
\code{ActivatedRule|OverrideAction}.
\item WafAction: Contains \code{Type}
}}

\item{DefaultAction}{A default action for the web ACL, either ALLOW or BLOCK. AWS WAF
performs the default action if a request doesn't match the criteria in
any of the rules in a web ACL.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic} in the developer guide.

See \url{https://www.paws-r-sdk.com/docs/wafregional_update_web_acl/} for full documentation.
}
\keyword{internal}
