% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_create_automation_rule}
\alias{securityhub_create_automation_rule}
\title{Creates an automation rule based on input parameters}
\usage{
securityhub_create_automation_rule(
  Tags = NULL,
  RuleStatus = NULL,
  RuleOrder,
  RuleName,
  Description,
  IsTerminal = NULL,
  Criteria,
  Actions
)
}
\arguments{
\item{Tags}{User-defined tags that help you label the purpose of a rule.}

\item{RuleStatus}{Whether the rule is active after it is created. If this parameter is
equal to \code{Enabled}, Security Hub will apply the rule to findings and
finding updates after the rule is created. To change the value of this
parameter after creating a rule, use
\code{\link[=securityhub_batch_update_automation_rules]{batch_update_automation_rules}}.}

\item{RuleOrder}{[required] An integer ranging from 1 to 1000 that represents the order in which the
rule action is applied to findings. Security Hub applies rules with
lower values for this parameter first.}

\item{RuleName}{[required] The name of the rule.}

\item{Description}{[required] A description of the rule.}

\item{IsTerminal}{Specifies whether a rule is the last to be applied with respect to a
finding that matches the rule criteria. This is useful when a finding
matches the criteria for multiple rules, and each rule has different
actions. If the value of this field is set to \code{true} for a rule,
Security Hub applies the rule action to a finding that matches the rule
criteria and won't evaluate other rules for the finding. The default
value of this field is \code{false}.}

\item{Criteria}{[required] A set of ASFF finding field attributes and corresponding expected values
that Security Hub uses to filter findings. If a finding matches the
conditions specified in this parameter, Security Hub applies the rule
action to the finding.}

\item{Actions}{[required] One or more actions to update finding fields if a finding matches the
conditions specified in \code{Criteria}.}
}
\description{
Creates an automation rule based on input parameters.

See \url{https://www.paws-r-sdk.com/docs/securityhub_create_automation_rule/} for full documentation.
}
\keyword{internal}
