% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_update_detector}
\alias{guardduty_update_detector}
\title{Updates the Amazon GuardDuty detector specified by the detectorId}
\usage{
guardduty_update_detector(
  DetectorId,
  Enable = NULL,
  FindingPublishingFrequency = NULL,
  DataSources = NULL,
  Features = NULL
)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector to update.}

\item{Enable}{Specifies whether the detector is enabled or not enabled.}

\item{FindingPublishingFrequency}{An enum value that specifies how frequently findings are exported, such
as to CloudWatch Events.}

\item{DataSources}{Describes which data sources will be updated.

There might be regional differences because some data sources might not
be available in all the Amazon Web Services Regions where GuardDuty is
presently supported. For more information, see \href{https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html}{Regions and endpoints}.}

\item{Features}{Provides the features that will be updated for the detector.}
}
\description{
Updates the Amazon GuardDuty detector specified by the detectorId.

See \url{https://www.paws-r-sdk.com/docs/guardduty_update_detector/} for full documentation.
}
\keyword{internal}
