% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssoadmin_operations.R
\name{ssoadmin_create_permission_set}
\alias{ssoadmin_create_permission_set}
\title{Creates a permission set within a specified Amazon Web Services SSO
instance}
\usage{
ssoadmin_create_permission_set(
  Name,
  Description = NULL,
  InstanceArn,
  SessionDuration = NULL,
  RelayState = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the PermissionSet.}

\item{Description}{The description of the PermissionSet.}

\item{InstanceArn}{[required] The ARN of the Amazon Web Services SSO instance under which the
operation will be executed. For more information about ARNs, see Amazon
Resource Names (ARNs) and Amazon Web Services Service Namespaces in the
\emph{Amazon Web Services General Reference}.}

\item{SessionDuration}{The length of time that the application user sessions are valid in the
ISO-8601 standard.}

\item{RelayState}{Used to redirect users within the application during the federation
authentication process.}

\item{Tags}{The tags to attach to the new PermissionSet.}
}
\description{
Creates a permission set within a specified Amazon Web Services SSO instance.

See \url{https://paws-r.github.io/docs/ssoadmin/create_permission_set.html} for full documentation.
}
\keyword{internal}
