% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_list_protection_groups}
\alias{shield_list_protection_groups}
\title{Retrieves ProtectionGroup objects for the account}
\usage{
shield_list_protection_groups(
  NextToken = NULL,
  MaxResults = NULL,
  InclusionFilters = NULL
)
}
\arguments{
\item{NextToken}{When you request a list of objects from Shield Advanced, if the response
does not include all of the remaining available objects, Shield Advanced
includes a \code{NextToken} value in the response. You can retrieve the next
batch of objects by requesting the list again and providing the token
that was returned by the prior call in your request.

You can indicate the maximum number of objects that you want Shield
Advanced to return for a single call with the \code{MaxResults} setting.
Shield Advanced will not return more than \code{MaxResults} objects, but may
return fewer, even if more objects are still available.

Whenever more objects remain that Shield Advanced has not yet returned
to you, the response will include a \code{NextToken} value.

On your first call to a list operation, leave this setting empty.}

\item{MaxResults}{The greatest number of objects that you want Shield Advanced to return
to the list request. Shield Advanced might return fewer objects than you
indicate in this setting, even if more objects are available. If there
are more objects remaining, Shield Advanced will always also return a
\code{NextToken} value in the response.

The default setting is 20.}

\item{InclusionFilters}{Narrows the set of protection groups that the call retrieves. You can
retrieve a single protection group by its name and you can retrieve all
protection groups that are configured with specific pattern or
aggregation settings. You can provide up to one criteria per filter
type. Shield Advanced returns the protection groups that exactly match
all of the search criteria that you provide.}
}
\description{
Retrieves ProtectionGroup objects for the account. You can retrieve all protection groups or you can provide filtering criteria and retrieve just the subset of protection groups that match the criteria.

See \url{https://paws-r.github.io/docs/shield/list_protection_groups.html} for full documentation.
}
\keyword{internal}
