% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_resync_mfa_device}
\alias{iam_resync_mfa_device}
\title{Synchronizes the specified MFA device with its IAM resource object on
the Amazon Web Services servers}
\usage{
iam_resync_mfa_device(
  UserName,
  SerialNumber,
  AuthenticationCode1,
  AuthenticationCode2
)
}
\arguments{
\item{UserName}{[required] The name of the user whose MFA device you want to resynchronize.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{SerialNumber}{[required] Serial number that uniquely identifies the MFA device.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{AuthenticationCode1}{[required] An authentication code emitted by the device.

The format for this parameter is a sequence of six digits.}

\item{AuthenticationCode2}{[required] A subsequent authentication code emitted by the device.

The format for this parameter is a sequence of six digits.}
}
\description{
Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers.

See \url{https://paws-r.github.io/docs/iam/resync_mfa_device.html} for full documentation.
}
\keyword{internal}
