% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_add_client_id_to_open_id_connect_provider}
\alias{iam_add_client_id_to_open_id_connect_provider}
\title{Adds a new client ID (also known as audience) to the list of client IDs
already registered for the specified IAM OpenID Connect (OIDC) provider
resource}
\usage{
iam_add_client_id_to_open_id_connect_provider(
  OpenIDConnectProviderArn,
  ClientID
)
}
\arguments{
\item{OpenIDConnectProviderArn}{[required] The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
resource to add the client ID to. You can get a list of OIDC provider
ARNs by using the
\code{\link[=iam_list_open_id_connect_providers]{list_open_id_connect_providers}}
operation.}

\item{ClientID}{[required] The client ID (also known as audience) to add to the IAM OpenID Connect
provider resource.}
}
\description{
Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource.

See \url{https://paws-r.github.io/docs/iam/add_client_id_to_open_id_connect_provider.html} for full documentation.
}
\keyword{internal}
