% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_resend_validation_email}
\alias{acm_resend_validation_email}
\title{Resends the email that requests domain ownership validation}
\usage{
acm_resend_validation_email(CertificateArn, Domain, ValidationDomain)
}
\arguments{
\item{CertificateArn}{[required] String that contains the ARN of the requested certificate. The
certificate ARN is generated and returned by the
\code{\link[=acm_request_certificate]{request_certificate}} action as soon as the
request is made. By default, using this parameter causes email to be
sent to all top-level domains you specified in the certificate request.
The ARN must be of the form:

\code{arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012}}

\item{Domain}{[required] The fully qualified domain name (FQDN) of the certificate that needs to
be validated.}

\item{ValidationDomain}{[required] The base validation domain that will act as the suffix of the email
addresses that are used to send the emails. This must be the same as the
\code{Domain} value or a superdomain of the \code{Domain} value. For example, if
you requested a certificate for \code{site.subdomain.example.com} and specify
a \strong{ValidationDomain} of \code{subdomain.example.com}, ACM sends email to
the domain registrant, technical contact, and administrative contact in
WHOIS and the following five addresses:
\itemize{
\item admin@subdomain.example.com
\item administrator@subdomain.example.com
\item hostmaster@subdomain.example.com
\item postmaster@subdomain.example.com
\item webmaster@subdomain.example.com
}}
}
\description{
Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking \strong{I Approve}. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see \href{https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html}{Configure Email for your Domain}.

See \url{https://paws-r.github.io/docs/acm/resend_validation_email.html} for full documentation.
}
\keyword{internal}
