# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ram_service.R
NULL

#' Accepts an invitation to a resource share from another Amazon Web
#' Services account
#'
#' @description
#' Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the invitation, the resources included in the resource share are available to interact with in the relevant Amazon Web Services Management Consoles and tools.
#'
#' See [https://paws-r.github.io/docs/ram/accept_resource_share_invitation.html](https://paws-r.github.io/docs/ram/accept_resource_share_invitation.html) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; The [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the invitation that you want to accept.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_accept_resource_share_invitation
ram_accept_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "AcceptResourceShareInvitation",
    http_method = "POST",
    http_path = "/acceptresourceshareinvitation",
    paginator = list()
  )
  input <- .ram$accept_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$accept_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$accept_resource_share_invitation <- ram_accept_resource_share_invitation

#' Adds the specified list of principals and list of resources to a
#' resource share
#'
#' @description
#' Adds the specified list of principals and list of resources to a resource share. Principals that already have access to this resource share immediately receive access to the added resources. Newly added principals immediately receive access to the resources shared in this resource share.
#'
#' See [https://paws-r.github.io/docs/ram/associate_resource_share.html](https://paws-r.github.io/docs/ram/associate_resource_share.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share that you want to add principals or resources to.
#' @param resourceArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resources that you want to share. This can be `null` if you want
#' to add only principals.
#' @param principals Specifies a list of principals to whom you want to the resource share.
#' This can be `null` if you want to add only resources.
#' 
#' What the principals can do with the resources in the share is determined
#' by the RAM permissions that you associate with the resource share. See
#' [`associate_resource_share_permission`][ram_associate_resource_share_permission].
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resoure Name
#'     (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_associate_resource_share
ram_associate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "AssociateResourceShare",
    http_method = "POST",
    http_path = "/associateresourceshare",
    paginator = list()
  )
  input <- .ram$associate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken)
  output <- .ram$associate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$associate_resource_share <- ram_associate_resource_share

#' Adds or replaces the RAM permission for a resource type included in a
#' resource share
#'
#' @description
#' Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one permission associated with each resource type in the resource share. You can add a new RAM permission only if there are currently no resources of that resource type currently in the resource share.
#'
#' See [https://paws-r.github.io/docs/ram/associate_resource_share_permission.html](https://paws-r.github.io/docs/ram/associate_resource_share_permission.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share to which you want to add or replace permissions.
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the RAM permission to associate with the resource share. To find the
#' ARN for a permission, use either the
#' [`list_permissions`][ram_list_permissions] operation or go to the
#' Permissions library page in the RAM console and then choose the name of
#' the permission. The ARN is displayed on the detail page.
#' @param replace Specifies whether the specified permission should replace or add to the
#' existing permission associated with the resource share. Use `true` to
#' replace the current permissions. Use `false` to add the permission to
#' the current permission. The default value is `false`.
#' 
#' A resource share can have only one permission per resource type. If a
#' resource share already has a permission for the specified resource type
#' and you don't set `replace` to `true` then the operation returns an
#' error. This helps prevent accidental overwriting of a permission.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' @param permissionVersion Specifies the version of the RAM permission to associate with the
#' resource share. If you don't specify this parameter, the operation uses
#' the version designated as the default. You can use the
#' [`list_permission_versions`][ram_list_permission_versions] operation to
#' discover the available versions of a permission.
#'
#' @keywords internal
#'
#' @rdname ram_associate_resource_share_permission
ram_associate_resource_share_permission <- function(resourceShareArn, permissionArn, replace = NULL, clientToken = NULL, permissionVersion = NULL) {
  op <- new_operation(
    name = "AssociateResourceSharePermission",
    http_method = "POST",
    http_path = "/associateresourcesharepermission",
    paginator = list()
  )
  input <- .ram$associate_resource_share_permission_input(resourceShareArn = resourceShareArn, permissionArn = permissionArn, replace = replace, clientToken = clientToken, permissionVersion = permissionVersion)
  output <- .ram$associate_resource_share_permission_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$associate_resource_share_permission <- ram_associate_resource_share_permission

#' Creates a resource share
#'
#' @description
#' Creates a resource share. You can provide a list of the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) for the resources that you want to share, a list of principals you want to share the resources with, and the permissions to grant those principals.
#'
#' See [https://paws-r.github.io/docs/ram/create_resource_share.html](https://paws-r.github.io/docs/ram/create_resource_share.html) for full documentation.
#'
#' @param name &#91;required&#93; Specifies the name of the resource share.
#' @param resourceArns Specifies a list of one or more ARNs of the resources to associate with
#' the resource share.
#' @param principals Specifies a list of one or more principals to associate with the
#' resource share.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resoure Name
#'     (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param tags Specifies one or more tags to attach to the resource share itself. It
#' doesn't attach the tags to the resources associated with the resource
#' share.
#' @param allowExternalPrincipals Specifies whether principals outside your organization in Organizations
#' can be associated with a resource share. A value of `true` lets you
#' share with individual Amazon Web Services accounts that are *not* in
#' your organization. A value of `false` only has meaning if your account
#' is a member of an Amazon Web Services Organization. The default value is
#' `true`.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' @param permissionArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the RAM permission to associate with the resource share. If you do
#' not specify an ARN for the permission, RAM automatically attaches the
#' default version of the permission for each resource type. You can
#' associate only one permission with each resource type included in the
#' resource share.
#'
#' @keywords internal
#'
#' @rdname ram_create_resource_share
ram_create_resource_share <- function(name, resourceArns = NULL, principals = NULL, tags = NULL, allowExternalPrincipals = NULL, clientToken = NULL, permissionArns = NULL) {
  op <- new_operation(
    name = "CreateResourceShare",
    http_method = "POST",
    http_path = "/createresourceshare",
    paginator = list()
  )
  input <- .ram$create_resource_share_input(name = name, resourceArns = resourceArns, principals = principals, tags = tags, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken, permissionArns = permissionArns)
  output <- .ram$create_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$create_resource_share <- ram_create_resource_share

#' Deletes the specified resource share
#'
#' @description
#' Deletes the specified resource share. This doesn't delete any of the resources that were associated with the resource share; it only stops the sharing of those resources outside of the Amazon Web Services account that created them.
#'
#' See [https://paws-r.github.io/docs/ram/delete_resource_share.html](https://paws-r.github.io/docs/ram/delete_resource_share.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share to delete.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_delete_resource_share
ram_delete_resource_share <- function(resourceShareArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteResourceShare",
    http_method = "DELETE",
    http_path = "/deleteresourceshare",
    paginator = list()
  )
  input <- .ram$delete_resource_share_input(resourceShareArn = resourceShareArn, clientToken = clientToken)
  output <- .ram$delete_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$delete_resource_share <- ram_delete_resource_share

#' Disassociates the specified principals or resources from the specified
#' resource share
#'
#' @description
#' Disassociates the specified principals or resources from the specified resource share.
#'
#' See [https://paws-r.github.io/docs/ram/disassociate_resource_share.html](https://paws-r.github.io/docs/ram/disassociate_resource_share.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share that you want to remove resources from.
#' @param resourceArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' for one or more resources that you want to remove from the resource
#' share. After the operation runs, these resources are no longer shared
#' with principals outside of the Amazon Web Services account that created
#' the resources.
#' @param principals Specifies a list of one or more principals that no longer are to have
#' access to the resources in this resource share.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resoure Name
#'     (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_disassociate_resource_share
ram_disassociate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "DisassociateResourceShare",
    http_method = "POST",
    http_path = "/disassociateresourceshare",
    paginator = list()
  )
  input <- .ram$disassociate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken)
  output <- .ram$disassociate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$disassociate_resource_share <- ram_disassociate_resource_share

#' Disassociates an RAM permission from a resource share
#'
#' @description
#' Disassociates an RAM permission from a resource share. Permission changes take effect immediately. You can remove a RAM permission from a resource share only if there are currently no resources of the relevant resource type currently attached to the resource share.
#'
#' See [https://paws-r.github.io/docs/ram/disassociate_resource_share_permission.html](https://paws-r.github.io/docs/ram/disassociate_resource_share_permission.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; The [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share from which you want to disassociate a permission.
#' @param permissionArn &#91;required&#93; The [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the permission to disassociate from the resource share. Changes to
#' permissions take effect immediately.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_disassociate_resource_share_permission
ram_disassociate_resource_share_permission <- function(resourceShareArn, permissionArn, clientToken = NULL) {
  op <- new_operation(
    name = "DisassociateResourceSharePermission",
    http_method = "POST",
    http_path = "/disassociateresourcesharepermission",
    paginator = list()
  )
  input <- .ram$disassociate_resource_share_permission_input(resourceShareArn = resourceShareArn, permissionArn = permissionArn, clientToken = clientToken)
  output <- .ram$disassociate_resource_share_permission_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$disassociate_resource_share_permission <- ram_disassociate_resource_share_permission

#' Enables resource sharing within your organization in Organizations
#'
#' @description
#' Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to retrieve information about the organization and its structure. This lets you share resources with all of the accounts in an organization by specifying the organization's ID, or all of the accounts in an organizational unit (OU) by specifying the OU's ID. Until you enable sharing within the organization, you can specify only individual Amazon Web Services accounts, or for supported resource types, IAM users and roles.
#'
#' See [https://paws-r.github.io/docs/ram/enable_sharing_with_aws_organization.html](https://paws-r.github.io/docs/ram/enable_sharing_with_aws_organization.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ram_enable_sharing_with_aws_organization
ram_enable_sharing_with_aws_organization <- function() {
  op <- new_operation(
    name = "EnableSharingWithAwsOrganization",
    http_method = "POST",
    http_path = "/enablesharingwithawsorganization",
    paginator = list()
  )
  input <- .ram$enable_sharing_with_aws_organization_input()
  output <- .ram$enable_sharing_with_aws_organization_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$enable_sharing_with_aws_organization <- ram_enable_sharing_with_aws_organization

#' Gets the contents of an RAM permission in JSON format
#'
#' @description
#' Gets the contents of an RAM permission in JSON format.
#'
#' See [https://paws-r.github.io/docs/ram/get_permission.html](https://paws-r.github.io/docs/ram/get_permission.html) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the permission whose contents you want to retrieve. To find the ARN
#' for a permission, use either the
#' [`list_permissions`][ram_list_permissions] operation or go to the
#' Permissions library page in the RAM console and then choose the name of
#' the permission. The ARN is displayed on the detail page.
#' @param permissionVersion Specifies identifier for the version of the RAM permission to retrieve.
#' If you don't specify this parameter, the operation retrieves the default
#' version.
#'
#' @keywords internal
#'
#' @rdname ram_get_permission
ram_get_permission <- function(permissionArn, permissionVersion = NULL) {
  op <- new_operation(
    name = "GetPermission",
    http_method = "POST",
    http_path = "/getpermission",
    paginator = list()
  )
  input <- .ram$get_permission_input(permissionArn = permissionArn, permissionVersion = permissionVersion)
  output <- .ram$get_permission_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_permission <- ram_get_permission

#' Retrieves the resource policies for the specified resources that you own
#' and have shared
#'
#' @description
#' Retrieves the resource policies for the specified resources that you own and have shared.
#'
#' See [https://paws-r.github.io/docs/ram/get_resource_policies.html](https://paws-r.github.io/docs/ram/get_resource_policies.html) for full documentation.
#'
#' @param resourceArns &#91;required&#93; Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resources whose policies you want to retrieve.
#' @param principal Specifies the principal.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_policies
ram_get_resource_policies <- function(resourceArns, principal = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/getresourcepolicies",
    paginator = list()
  )
  input <- .ram$get_resource_policies_input(resourceArns = resourceArns, principal = principal, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_policies_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_policies <- ram_get_resource_policies

#' Retrieves the resource and principal associations for resource shares
#' that you own
#'
#' @description
#' Retrieves the resource and principal associations for resource shares that you own.
#'
#' See [https://paws-r.github.io/docs/ram/get_resource_share_associations.html](https://paws-r.github.io/docs/ram/get_resource_share_associations.html) for full documentation.
#'
#' @param associationType &#91;required&#93; Specifies whether you want to retrieve the associations that involve a
#' specified resource or principal.
#' 
#' -   `PRINCIPAL` – list the principals that are associated with the
#'     specified resource share.
#' 
#' -   `RESOURCE` – list the resources that are associated with the
#'     specified resource share.
#' @param resourceShareArns Specifies a list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share whose associations you want to retrieve.
#' @param resourceArn Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource whose resource shares you want to retrieve.
#' 
#' You cannot specify this parameter if the association type is
#' `PRINCIPAL`.
#' @param principal Specifies the ID of the principal whose resource shares you want to
#' retrieve. This can be an Amazon Web Services account ID, an organization
#' ID, an organizational unit ID, or the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an individual IAM user or role.
#' 
#' You cannot specify this parameter if the association type is `RESOURCE`.
#' @param associationStatus Specifies that you want to retrieve only associations with this status.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_associations
ram_get_resource_share_associations <- function(associationType, resourceShareArns = NULL, resourceArn = NULL, principal = NULL, associationStatus = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareAssociations",
    http_method = "POST",
    http_path = "/getresourceshareassociations",
    paginator = list()
  )
  input <- .ram$get_resource_share_associations_input(associationType = associationType, resourceShareArns = resourceShareArns, resourceArn = resourceArn, principal = principal, associationStatus = associationStatus, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_associations_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_associations <- ram_get_resource_share_associations

#' Retrieves details about invitations that you have received for resource
#' shares
#'
#' @description
#' Retrieves details about invitations that you have received for resource shares.
#'
#' See [https://paws-r.github.io/docs/ram/get_resource_share_invitations.html](https://paws-r.github.io/docs/ram/get_resource_share_invitations.html) for full documentation.
#'
#' @param resourceShareInvitationArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share invitations you want information about.
#' @param resourceShareArns Specifies that you want details about invitations only for the resource
#' shares described by this list of [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_invitations
ram_get_resource_share_invitations <- function(resourceShareInvitationArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareInvitations",
    http_method = "POST",
    http_path = "/getresourceshareinvitations",
    paginator = list()
  )
  input <- .ram$get_resource_share_invitations_input(resourceShareInvitationArns = resourceShareInvitationArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_invitations_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_invitations <- ram_get_resource_share_invitations

#' Retrieves details about the resource shares that you own or that are
#' shared with you
#'
#' @description
#' Retrieves details about the resource shares that you own or that are shared with you.
#'
#' See [https://paws-r.github.io/docs/ram/get_resource_shares.html](https://paws-r.github.io/docs/ram/get_resource_shares.html) for full documentation.
#'
#' @param resourceShareArns Specifies the [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of individual resource shares that you want information about.
#' @param resourceShareStatus Specifies that you want to retrieve details of only those resource
#' shares that have this status.
#' @param resourceOwner &#91;required&#93; Specifies that you want to retrieve details of only those resource
#' shares that match the following:
#' 
#' -   **`SELF`** – resource shares that your account shares with other
#'     accounts
#' 
#' -   **`OTHER-ACCOUNTS`** – resource shares that other accounts share
#'     with your account
#' @param name Specifies the name of an individual resource share that you want to
#' retrieve details about.
#' @param tagFilters Specifies that you want to retrieve details of only those resource
#' shares that match the specified tag keys and values.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param permissionArn Specifies that you want to retrieve details of only those resource
#' shares that use the RAM permission with this [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_shares
ram_get_resource_shares <- function(resourceShareArns = NULL, resourceShareStatus = NULL, resourceOwner, name = NULL, tagFilters = NULL, nextToken = NULL, maxResults = NULL, permissionArn = NULL) {
  op <- new_operation(
    name = "GetResourceShares",
    http_method = "POST",
    http_path = "/getresourceshares",
    paginator = list()
  )
  input <- .ram$get_resource_shares_input(resourceShareArns = resourceShareArns, resourceShareStatus = resourceShareStatus, resourceOwner = resourceOwner, name = name, tagFilters = tagFilters, nextToken = nextToken, maxResults = maxResults, permissionArn = permissionArn)
  output <- .ram$get_resource_shares_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_shares <- ram_get_resource_shares

#' Lists the resources in a resource share that is shared with you but for
#' which the invitation is still PENDING
#'
#' @description
#' Lists the resources in a resource share that is shared with you but for which the invitation is still `PENDING`. That means that you haven't accepted or rejected the invitation and the invitation hasn't expired.
#'
#' See [https://paws-r.github.io/docs/ram/list_pending_invitation_resources.html](https://paws-r.github.io/docs/ram/list_pending_invitation_resources.html) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the invitation. You can use
#' [`get_resource_share_invitations`][ram_get_resource_share_invitations]
#' to find the ARN of the invitation.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_pending_invitation_resources
ram_list_pending_invitation_resources <- function(resourceShareInvitationArn, nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListPendingInvitationResources",
    http_method = "POST",
    http_path = "/listpendinginvitationresources",
    paginator = list()
  )
  input <- .ram$list_pending_invitation_resources_input(resourceShareInvitationArn = resourceShareInvitationArn, nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_pending_invitation_resources_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_pending_invitation_resources <- ram_list_pending_invitation_resources

#' Lists the available versions of the specified RAM permission
#'
#' @description
#' Lists the available versions of the specified RAM permission.
#'
#' See [https://paws-r.github.io/docs/ram/list_permission_versions.html](https://paws-r.github.io/docs/ram/list_permission_versions.html) for full documentation.
#'
#' @param permissionArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the RAM permission whose versions you want to list. You can use the
#' `permissionVersion` parameter on the
#' [`associate_resource_share_permission`][ram_associate_resource_share_permission]
#' operation to specify a non-default version to attach.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_permission_versions
ram_list_permission_versions <- function(permissionArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPermissionVersions",
    http_method = "POST",
    http_path = "/listpermissionversions",
    paginator = list()
  )
  input <- .ram$list_permission_versions_input(permissionArn = permissionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_permission_versions_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_permission_versions <- ram_list_permission_versions

#' Retrieves a list of available RAM permissions that you can use for the
#' supported resource types
#'
#' @description
#' Retrieves a list of available RAM permissions that you can use for the supported resource types.
#'
#' See [https://paws-r.github.io/docs/ram/list_permissions.html](https://paws-r.github.io/docs/ram/list_permissions.html) for full documentation.
#'
#' @param resourceType Specifies that you want to list permissions for only the specified
#' resource type. For example, to list only permissions that apply to EC2
#' subnets, specify `ec2:Subnet`. You can use the
#' [`list_resource_types`][ram_list_resource_types] operation to get the
#' specific string required.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_permissions
ram_list_permissions <- function(resourceType = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/listpermissions",
    paginator = list()
  )
  input <- .ram$list_permissions_input(resourceType = resourceType, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_permissions_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_permissions <- ram_list_permissions

#' Lists the principals that you are sharing resources with or that are
#' sharing resources with you
#'
#' @description
#' Lists the principals that you are sharing resources with or that are sharing resources with you.
#'
#' See [https://paws-r.github.io/docs/ram/list_principals.html](https://paws-r.github.io/docs/ram/list_principals.html) for full documentation.
#'
#' @param resourceOwner &#91;required&#93; Specifies that you want to list information for only resource shares
#' that match the following:
#' 
#' -   **`SELF`** – principals that your account is sharing resources with
#' 
#' -   **`OTHER-ACCOUNTS`** – principals that are sharing resources with
#'     your account
#' @param resourceArn Specifies that you want to list principal information for the resource
#' share with the specified [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param principals Specifies that you want to list information for only the listed
#' principals.
#' 
#' You can include the following values:
#' 
#' -   An Amazon Web Services account ID, for example: `123456789012`
#' 
#' -   An [Amazon Resoure Name
#'     (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#'     of an organization in Organizations, for example:
#'     `organizations::123456789012:organization/o-exampleorgid`
#' 
#' -   An ARN of an organizational unit (OU) in Organizations, for example:
#'     `organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123`
#' 
#' -   An ARN of an IAM role, for example:
#'     `iam::123456789012:role/rolename`
#' 
#' -   An ARN of an IAM user, for example: `iam::123456789012user/username`
#' 
#' Not all resource types can be shared with IAM roles and users. For more
#' information, see [Sharing with IAM roles and
#' users](https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types)
#' in the *Resource Access Manager User Guide*.
#' @param resourceType Specifies that you want to list information for only principals
#' associated with resource shares that include the specified resource
#' type.
#' 
#' For a list of valid values, query the
#' [`list_resource_types`][ram_list_resource_types] operation.
#' @param resourceShareArns Specifies that you want to list information for only principals
#' associated with the resource shares specified by a list the [Amazon
#' Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_principals
ram_list_principals <- function(resourceOwner, resourceArn = NULL, principals = NULL, resourceType = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPrincipals",
    http_method = "POST",
    http_path = "/listprincipals",
    paginator = list()
  )
  input <- .ram$list_principals_input(resourceOwner = resourceOwner, resourceArn = resourceArn, principals = principals, resourceType = resourceType, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_principals_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_principals <- ram_list_principals

#' Lists the RAM permissions that are associated with a resource share
#'
#' @description
#' Lists the RAM permissions that are associated with a resource share.
#'
#' See [https://paws-r.github.io/docs/ram/list_resource_share_permissions.html](https://paws-r.github.io/docs/ram/list_resource_share_permissions.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share for which you want to retrieve the associated
#' permissions.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#'
#' @keywords internal
#'
#' @rdname ram_list_resource_share_permissions
ram_list_resource_share_permissions <- function(resourceShareArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListResourceSharePermissions",
    http_method = "POST",
    http_path = "/listresourcesharepermissions",
    paginator = list()
  )
  input <- .ram$list_resource_share_permissions_input(resourceShareArn = resourceShareArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_resource_share_permissions_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resource_share_permissions <- ram_list_resource_share_permissions

#' Lists the resource types that can be shared by RAM
#'
#' @description
#' Lists the resource types that can be shared by RAM.
#'
#' See [https://paws-r.github.io/docs/ram/list_resource_types.html](https://paws-r.github.io/docs/ram/list_resource_types.html) for full documentation.
#'
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_resource_types
ram_list_resource_types <- function(nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListResourceTypes",
    http_method = "POST",
    http_path = "/listresourcetypes",
    paginator = list()
  )
  input <- .ram$list_resource_types_input(nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_resource_types_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resource_types <- ram_list_resource_types

#' Lists the resources that you added to a resource share or the resources
#' that are shared with you
#'
#' @description
#' Lists the resources that you added to a resource share or the resources that are shared with you.
#'
#' See [https://paws-r.github.io/docs/ram/list_resources.html](https://paws-r.github.io/docs/ram/list_resources.html) for full documentation.
#'
#' @param resourceOwner &#91;required&#93; Specifies that you want to list only the resource shares that match the
#' following:
#' 
#' -   **`SELF`** – resources that your account shares with other accounts
#' 
#' -   **`OTHER-ACCOUNTS`** – resources that other accounts share with your
#'     account
#' @param principal Specifies that you want to list only the resource shares that are
#' associated with the specified principal.
#' @param resourceType Specifies that you want to list only the resource shares that include
#' resources of the specified resource type.
#' 
#' For valid values, query the
#' [`list_resource_types`][ram_list_resource_types] operation.
#' @param resourceArns Specifies that you want to list only the resource shares that include
#' resources with the specified [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param resourceShareArns Specifies that you want to list only resources in the resource shares
#' identified by the specified [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included on each
#' page of the response. If you do not include this parameter, it defaults
#' to a value that is specific to the operation. If additional items exist
#' beyond the number you specify, the `NextToken` response element is
#' returned with a value (not null). Include the specified value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results. Note that the service might return fewer
#' results than the maximum even when there are more results available. You
#' should check `NextToken` after every operation to ensure that you
#' receive all of the results.
#' @param resourceRegionScope Specifies that you want the results to include only resources that have
#' the specified scope.
#' 
#' -   `ALL` – the results include both global and regional resources or
#'     resource types.
#' 
#' -   `GLOBAL` – the results include only global resources or resource
#'     types.
#' 
#' -   `REGIONAL` – the results include only regional resources or resource
#'     types.
#' 
#' The default value is `ALL`.
#'
#' @keywords internal
#'
#' @rdname ram_list_resources
ram_list_resources <- function(resourceOwner, principal = NULL, resourceType = NULL, resourceArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL, resourceRegionScope = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/listresources",
    paginator = list()
  )
  input <- .ram$list_resources_input(resourceOwner = resourceOwner, principal = principal, resourceType = resourceType, resourceArns = resourceArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults, resourceRegionScope = resourceRegionScope)
  output <- .ram$list_resources_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resources <- ram_list_resources

#' When you attach a resource-based permission policy to a resource, it
#' automatically creates a resource share
#'
#' @description
#' When you attach a resource-based permission policy to a resource, it automatically creates a resource share. However, resource shares created this way are visible only to the resource share owner, and the resource share can't be modified in RAM.
#'
#' See [https://paws-r.github.io/docs/ram/promote_resource_share_created_from_policy.html](https://paws-r.github.io/docs/ram/promote_resource_share_created_from_policy.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share to promote.
#'
#' @keywords internal
#'
#' @rdname ram_promote_resource_share_created_from_policy
ram_promote_resource_share_created_from_policy <- function(resourceShareArn) {
  op <- new_operation(
    name = "PromoteResourceShareCreatedFromPolicy",
    http_method = "POST",
    http_path = "/promoteresourcesharecreatedfrompolicy",
    paginator = list()
  )
  input <- .ram$promote_resource_share_created_from_policy_input(resourceShareArn = resourceShareArn)
  output <- .ram$promote_resource_share_created_from_policy_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$promote_resource_share_created_from_policy <- ram_promote_resource_share_created_from_policy

#' Rejects an invitation to a resource share from another Amazon Web
#' Services account
#'
#' @description
#' Rejects an invitation to a resource share from another Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/ram/reject_resource_share_invitation.html](https://paws-r.github.io/docs/ram/reject_resource_share_invitation.html) for full documentation.
#'
#' @param resourceShareInvitationArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the invitation that you want to reject.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_reject_resource_share_invitation
ram_reject_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "RejectResourceShareInvitation",
    http_method = "POST",
    http_path = "/rejectresourceshareinvitation",
    paginator = list()
  )
  input <- .ram$reject_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$reject_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$reject_resource_share_invitation <- ram_reject_resource_share_invitation

#' Adds the specified tag keys and values to the specified resource share
#'
#' @description
#' Adds the specified tag keys and values to the specified resource share. The tags are attached only to the resource share, not to the resources that are in the resource share.
#'
#' See [https://paws-r.github.io/docs/ram/tag_resource.html](https://paws-r.github.io/docs/ram/tag_resource.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share that you want to add tags to.
#' @param tags &#91;required&#93; A list of one or more tag key and value pairs. The tag key must be
#' present and not be an empty string. The tag value must be present but
#' can be an empty string.
#'
#' @keywords internal
#'
#' @rdname ram_tag_resource
ram_tag_resource <- function(resourceShareArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tagresource",
    paginator = list()
  )
  input <- .ram$tag_resource_input(resourceShareArn = resourceShareArn, tags = tags)
  output <- .ram$tag_resource_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$tag_resource <- ram_tag_resource

#' Removes the specified tag key and value pairs from the specified
#' resource share
#'
#' @description
#' Removes the specified tag key and value pairs from the specified resource share.
#'
#' See [https://paws-r.github.io/docs/ram/untag_resource.html](https://paws-r.github.io/docs/ram/untag_resource.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share that you want to remove tags from. The tags are
#' removed from the resource share, not the resources in the resource
#' share.
#' @param tagKeys &#91;required&#93; Specifies a list of one or more tag keys that you want to remove.
#'
#' @keywords internal
#'
#' @rdname ram_untag_resource
ram_untag_resource <- function(resourceShareArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untagresource",
    paginator = list()
  )
  input <- .ram$untag_resource_input(resourceShareArn = resourceShareArn, tagKeys = tagKeys)
  output <- .ram$untag_resource_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$untag_resource <- ram_untag_resource

#' Modifies some of the properties of the specified resource share
#'
#' @description
#' Modifies some of the properties of the specified resource share.
#'
#' See [https://paws-r.github.io/docs/ram/update_resource_share.html](https://paws-r.github.io/docs/ram/update_resource_share.html) for full documentation.
#'
#' @param resourceShareArn &#91;required&#93; Specifies the [Amazon Resoure Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the resource share that you want to modify.
#' @param name If specified, the new name that you want to attach to the resource
#' share.
#' @param allowExternalPrincipals Specifies whether principals outside your organization in Organizations
#' can be associated with a resource share.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#'
#' @keywords internal
#'
#' @rdname ram_update_resource_share
ram_update_resource_share <- function(resourceShareArn, name = NULL, allowExternalPrincipals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateResourceShare",
    http_method = "POST",
    http_path = "/updateresourceshare",
    paginator = list()
  )
  input <- .ram$update_resource_share_input(resourceShareArn = resourceShareArn, name = name, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken)
  output <- .ram$update_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$update_resource_share <- ram_update_resource_share
