# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' IAM Roles Anywhere
#'
#' @description
#' AWS Identity and Access Management Roles Anywhere provides a secure way
#' for your workloads such as servers, containers, and applications running
#' outside of AWS to obtain Temporary AWS credentials. Your workloads can
#' use the same IAM policies and roles that you have configured with native
#' AWS applications to access AWS resources. Using IAM Roles Anywhere will
#' eliminate the need to manage long term credentials for workloads running
#' outside of AWS.
#' 
#' To use IAM Roles Anywhere customer workloads will need to use X.509
#' certificates issued by their Certificate Authority (CA) . The
#' Certificate Authority (CA) needs to be registered with IAM Roles
#' Anywhere as a trust anchor to establish trust between customer PKI and
#' IAM Roles Anywhere. Customers who do not manage their own PKI system can
#' use AWS Certificate Manager Private Certificate Authority (ACM PCA) to
#' create a Certificate Authority and use that to establish trust with IAM
#' Roles Anywhere
#' 
#' This guide describes the IAM rolesanywhere operations that you can call
#' programmatically. For general information about IAM Roles Anywhere see
#' <https://docs.aws.amazon.com/>
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- iamrolesanywhere(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- iamrolesanywhere()
#' svc$create_profile(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=iamrolesanywhere_create_profile]{create_profile} \tab Creates a profile\cr
#'  \link[=iamrolesanywhere_create_trust_anchor]{create_trust_anchor} \tab Creates a trust anchor\cr
#'  \link[=iamrolesanywhere_delete_crl]{delete_crl} \tab Deletes a certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_delete_profile]{delete_profile} \tab Deletes a profile\cr
#'  \link[=iamrolesanywhere_delete_trust_anchor]{delete_trust_anchor} \tab Deletes a trust anchor\cr
#'  \link[=iamrolesanywhere_disable_crl]{disable_crl} \tab Disables a certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_disable_profile]{disable_profile} \tab Disables a profile\cr
#'  \link[=iamrolesanywhere_disable_trust_anchor]{disable_trust_anchor} \tab Disables a trust anchor\cr
#'  \link[=iamrolesanywhere_enable_crl]{enable_crl} \tab Enables a certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_enable_profile]{enable_profile} \tab Enables the roles in a profile to receive session credentials in CreateSession\cr
#'  \link[=iamrolesanywhere_enable_trust_anchor]{enable_trust_anchor} \tab Enables a trust anchor\cr
#'  \link[=iamrolesanywhere_get_crl]{get_crl} \tab Gets a certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_get_profile]{get_profile} \tab Gets a profile\cr
#'  \link[=iamrolesanywhere_get_subject]{get_subject} \tab Gets a Subject\cr
#'  \link[=iamrolesanywhere_get_trust_anchor]{get_trust_anchor} \tab Gets a trust anchor\cr
#'  \link[=iamrolesanywhere_import_crl]{import_crl} \tab Imports the certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_list_crls]{list_crls} \tab Lists all Crls in the authenticated account and Amazon Web Services Region\cr
#'  \link[=iamrolesanywhere_list_profiles]{list_profiles} \tab Lists all profiles in the authenticated account and Amazon Web Services Region\cr
#'  \link[=iamrolesanywhere_list_subjects]{list_subjects} \tab Lists the subjects in the authenticated account and Amazon Web Services Region\cr
#'  \link[=iamrolesanywhere_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags attached to the resource\cr
#'  \link[=iamrolesanywhere_list_trust_anchors]{list_trust_anchors} \tab Lists the trust anchors in the authenticated account and Amazon Web Services Region\cr
#'  \link[=iamrolesanywhere_tag_resource]{tag_resource} \tab Attaches tags to a resource\cr
#'  \link[=iamrolesanywhere_untag_resource]{untag_resource} \tab Removes tags from the resource\cr
#'  \link[=iamrolesanywhere_update_crl]{update_crl} \tab Updates the certificate revocation list (CRL)\cr
#'  \link[=iamrolesanywhere_update_profile]{update_profile} \tab Updates the profile\cr
#'  \link[=iamrolesanywhere_update_trust_anchor]{update_trust_anchor} \tab Updates the trust anchor
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname iamrolesanywhere
#' @export
iamrolesanywhere <- function(config = list()) {
  svc <- .iamrolesanywhere$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.iamrolesanywhere <- list()

.iamrolesanywhere$operations <- list()

.iamrolesanywhere$metadata <- list(
  service_name = "iamrolesanywhere",
  endpoints = list("*" = list(endpoint = "rolesanywhere.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "rolesanywhere.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "rolesanywhere.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "rolesanywhere.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "RolesAnywhere",
  api_version = "2018-05-10",
  signing_name = "rolesanywhere",
  json_version = "1.1",
  target_prefix = ""
)

.iamrolesanywhere$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.iamrolesanywhere$metadata, handlers, config)
}
