# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cognitoidentity_service.R
NULL

#' Creates a new identity pool
#'
#' @description
#' Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The keys for `SupportedLoginProviders` are as follows:
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/create_identity_pool.html](https://paws-r.github.io/docs/cognitoidentity/create_identity_pool.html) for full documentation.
#'
#' @param IdentityPoolName &#91;required&#93; A string that you provide.
#' @param AllowUnauthenticatedIdentities &#91;required&#93; TRUE if the identity pool supports unauthenticated logins.
#' @param AllowClassicFlow Enables or disables the Basic (Classic) authentication flow. For more
#' information, see [Identity Pools (Federated Identities) Authentication
#' Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html)
#' in the *Amazon Cognito Developer Guide*.
#' @param SupportedLoginProviders Optional key:value pairs mapping provider names to provider app IDs.
#' @param DeveloperProviderName The "domain" by which Cognito will refer to your users. This name acts
#' as a placeholder that allows your backend and the Cognito service to
#' communicate about the developer provider. For the
#' `DeveloperProviderName`, you can use letters as well as period (`.`),
#' underscore (`_`), and dash (`-`).
#' 
#' Once you have set a developer provider name, you cannot change it.
#' Please take care in setting this parameter.
#' @param OpenIdConnectProviderARNs The Amazon Resource Names (ARN) of the OpenID Connect providers.
#' @param CognitoIdentityProviders An array of Amazon Cognito user pools and their client IDs.
#' @param SamlProviderARNs An array of Amazon Resource Names (ARNs) of the SAML provider for your
#' identity pool.
#' @param IdentityPoolTags Tags to assign to the identity pool. A tag is a label that you can apply
#' to identity pools to categorize and manage them in different ways, such
#' as by purpose, owner, environment, or other criteria.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_create_identity_pool
cognitoidentity_create_identity_pool <- function(IdentityPoolName, AllowUnauthenticatedIdentities, AllowClassicFlow = NULL, SupportedLoginProviders = NULL, DeveloperProviderName = NULL, OpenIdConnectProviderARNs = NULL, CognitoIdentityProviders = NULL, SamlProviderARNs = NULL, IdentityPoolTags = NULL) {
  op <- new_operation(
    name = "CreateIdentityPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$create_identity_pool_input(IdentityPoolName = IdentityPoolName, AllowUnauthenticatedIdentities = AllowUnauthenticatedIdentities, AllowClassicFlow = AllowClassicFlow, SupportedLoginProviders = SupportedLoginProviders, DeveloperProviderName = DeveloperProviderName, OpenIdConnectProviderARNs = OpenIdConnectProviderARNs, CognitoIdentityProviders = CognitoIdentityProviders, SamlProviderARNs = SamlProviderARNs, IdentityPoolTags = IdentityPoolTags)
  output <- .cognitoidentity$create_identity_pool_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$create_identity_pool <- cognitoidentity_create_identity_pool

#' Deletes identities from an identity pool
#'
#' @description
#' Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/delete_identities.html](https://paws-r.github.io/docs/cognitoidentity/delete_identities.html) for full documentation.
#'
#' @param IdentityIdsToDelete &#91;required&#93; A list of 1-60 identities that you want to delete.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_delete_identities
cognitoidentity_delete_identities <- function(IdentityIdsToDelete) {
  op <- new_operation(
    name = "DeleteIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$delete_identities_input(IdentityIdsToDelete = IdentityIdsToDelete)
  output <- .cognitoidentity$delete_identities_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$delete_identities <- cognitoidentity_delete_identities

#' Deletes an identity pool
#'
#' @description
#' Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/delete_identity_pool.html](https://paws-r.github.io/docs/cognitoidentity/delete_identity_pool.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_delete_identity_pool
cognitoidentity_delete_identity_pool <- function(IdentityPoolId) {
  op <- new_operation(
    name = "DeleteIdentityPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$delete_identity_pool_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitoidentity$delete_identity_pool_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$delete_identity_pool <- cognitoidentity_delete_identity_pool

#' Returns metadata related to the given identity, including when the
#' identity was created and any associated linked logins
#'
#' @description
#' Returns metadata related to the given identity, including when the identity was created and any associated linked logins.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/describe_identity.html](https://paws-r.github.io/docs/cognitoidentity/describe_identity.html) for full documentation.
#'
#' @param IdentityId &#91;required&#93; A unique identifier in the format REGION:GUID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_describe_identity
cognitoidentity_describe_identity <- function(IdentityId) {
  op <- new_operation(
    name = "DescribeIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$describe_identity_input(IdentityId = IdentityId)
  output <- .cognitoidentity$describe_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$describe_identity <- cognitoidentity_describe_identity

#' Gets details about a particular identity pool, including the pool name,
#' ID description, creation date, and current number of users
#'
#' @description
#' Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/describe_identity_pool.html](https://paws-r.github.io/docs/cognitoidentity/describe_identity_pool.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_describe_identity_pool
cognitoidentity_describe_identity_pool <- function(IdentityPoolId) {
  op <- new_operation(
    name = "DescribeIdentityPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$describe_identity_pool_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitoidentity$describe_identity_pool_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$describe_identity_pool <- cognitoidentity_describe_identity_pool

#' Returns credentials for the provided identity ID
#'
#' @description
#' Returns credentials for the provided identity ID. Any provided logins will be validated against supported login providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service with the appropriate role for the token.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_credentials_for_identity.html](https://paws-r.github.io/docs/cognitoidentity/get_credentials_for_identity.html) for full documentation.
#'
#' @param IdentityId &#91;required&#93; A unique identifier in the format REGION:GUID.
#' @param Logins A set of optional name-value pairs that map provider names to provider
#' tokens. The name-value pair will follow the syntax "provider_name":
#' "provider_user_identifier".
#' 
#' Logins should not be specified when trying to get credentials for an
#' unauthenticated identity.
#' 
#' The Logins parameter is required when using identities associated with
#' external identity providers such as Facebook. For examples of `Logins`
#' maps, see the code examples in the [External Identity
#' Providers](https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html)
#' section of the Amazon Cognito Developer Guide.
#' @param CustomRoleArn The Amazon Resource Name (ARN) of the role to be assumed when multiple
#' roles were received in the token from the identity provider. For
#' example, a SAML-based identity provider. This parameter is optional for
#' identity providers that do not support role customization.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_credentials_for_identity
cognitoidentity_get_credentials_for_identity <- function(IdentityId, Logins = NULL, CustomRoleArn = NULL) {
  op <- new_operation(
    name = "GetCredentialsForIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_credentials_for_identity_input(IdentityId = IdentityId, Logins = Logins, CustomRoleArn = CustomRoleArn)
  output <- .cognitoidentity$get_credentials_for_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_credentials_for_identity <- cognitoidentity_get_credentials_for_identity

#' Generates (or retrieves) a Cognito ID
#'
#' @description
#' Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_id.html](https://paws-r.github.io/docs/cognitoidentity/get_id.html) for full documentation.
#'
#' @param AccountId A standard AWS account ID (9+ digits).
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param Logins A set of optional name-value pairs that map provider names to provider
#' tokens. The available provider names for `Logins` are as follows:
#' 
#' -   Facebook: `graph.facebook.com`
#' 
#' -   Amazon Cognito user pool:
#'     `cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>`, for
#'     example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
#' 
#' -   Google: `accounts.google.com`
#' 
#' -   Amazon: `www.amazon.com`
#' 
#' -   Twitter: `api.twitter.com`
#' 
#' -   Digits: `www.digits.com`
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_id
cognitoidentity_get_id <- function(AccountId = NULL, IdentityPoolId, Logins = NULL) {
  op <- new_operation(
    name = "GetId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_id_input(AccountId = AccountId, IdentityPoolId = IdentityPoolId, Logins = Logins)
  output <- .cognitoidentity$get_id_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_id <- cognitoidentity_get_id

#' Gets the roles for an identity pool
#'
#' @description
#' Gets the roles for an identity pool.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_identity_pool_roles.html](https://paws-r.github.io/docs/cognitoidentity/get_identity_pool_roles.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_identity_pool_roles
cognitoidentity_get_identity_pool_roles <- function(IdentityPoolId) {
  op <- new_operation(
    name = "GetIdentityPoolRoles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_identity_pool_roles_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitoidentity$get_identity_pool_roles_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_identity_pool_roles <- cognitoidentity_get_identity_pool_roles

#' Gets an OpenID token, using a known Cognito ID
#'
#' @description
#' Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by [`get_id`][cognitoidentity_get_id]. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_open_id_token.html](https://paws-r.github.io/docs/cognitoidentity/get_open_id_token.html) for full documentation.
#'
#' @param IdentityId &#91;required&#93; A unique identifier in the format REGION:GUID.
#' @param Logins A set of optional name-value pairs that map provider names to provider
#' tokens. When using graph.facebook.com and www.amazon.com, supply the
#' access_token returned from the provider's authflow. For
#' accounts.google.com, an Amazon Cognito user pool provider, or any other
#' OpenID Connect provider, always include the `id_token`.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_open_id_token
cognitoidentity_get_open_id_token <- function(IdentityId, Logins = NULL) {
  op <- new_operation(
    name = "GetOpenIdToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_open_id_token_input(IdentityId = IdentityId, Logins = Logins)
  output <- .cognitoidentity$get_open_id_token_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_open_id_token <- cognitoidentity_get_open_id_token

#' Registers (or retrieves) a Cognito IdentityId and an OpenID Connect
#' token for a user authenticated by your backend authentication process
#'
#' @description
#' Registers (or retrieves) a Cognito `IdentityId` and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the `Logins` map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_open_id_token_for_developer_identity.html](https://paws-r.github.io/docs/cognitoidentity/get_open_id_token_for_developer_identity.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param IdentityId A unique identifier in the format REGION:GUID.
#' @param Logins &#91;required&#93; A set of optional name-value pairs that map provider names to provider
#' tokens. Each name-value pair represents a user from a public provider or
#' developer provider. If the user is from a developer provider, the
#' name-value pair will follow the syntax
#' `"developer_provider_name": "developer_user_identifier"`. The developer
#' provider is the "domain" by which Cognito will refer to your users; you
#' provided this domain while creating/updating the identity pool. The
#' developer user identifier is an identifier from your backend that
#' uniquely identifies a user. When you create an identity pool, you can
#' specify the supported logins.
#' @param PrincipalTags Use this operation to configure attribute mappings for custom providers.
#' @param TokenDuration The expiration time of the token, in seconds. You can specify a custom
#' expiration time for the token so that you can cache it. If you don't
#' provide an expiration time, the token is valid for 15 minutes. You can
#' exchange the token with Amazon STS for temporary AWS credentials, which
#' are valid for a maximum of one hour. The maximum token duration you can
#' set is 24 hours. You should take care in setting the expiration time for
#' a token, as there are significant security implications: an attacker
#' could use a leaked token to access your AWS resources for the token's
#' duration.
#' 
#' Please provide for a small grace period, usually no more than 5 minutes,
#' to account for clock skew.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_open_id_token_for_developer_identity
cognitoidentity_get_open_id_token_for_developer_identity <- function(IdentityPoolId, IdentityId = NULL, Logins, PrincipalTags = NULL, TokenDuration = NULL) {
  op <- new_operation(
    name = "GetOpenIdTokenForDeveloperIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_open_id_token_for_developer_identity_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, Logins = Logins, PrincipalTags = PrincipalTags, TokenDuration = TokenDuration)
  output <- .cognitoidentity$get_open_id_token_for_developer_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_open_id_token_for_developer_identity <- cognitoidentity_get_open_id_token_for_developer_identity

#' Use GetPrincipalTagAttributeMap to list all mappings between
#' PrincipalTags and user attributes
#'
#' @description
#' Use [`get_principal_tag_attribute_map`][cognitoidentity_get_principal_tag_attribute_map] to list all mappings between `PrincipalTags` and user attributes.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/get_principal_tag_attribute_map.html](https://paws-r.github.io/docs/cognitoidentity/get_principal_tag_attribute_map.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; You can use this operation to get the ID of the Identity Pool you setup
#' attribute mappings for.
#' @param IdentityProviderName &#91;required&#93; You can use this operation to get the provider name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_get_principal_tag_attribute_map
cognitoidentity_get_principal_tag_attribute_map <- function(IdentityPoolId, IdentityProviderName) {
  op <- new_operation(
    name = "GetPrincipalTagAttributeMap",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$get_principal_tag_attribute_map_input(IdentityPoolId = IdentityPoolId, IdentityProviderName = IdentityProviderName)
  output <- .cognitoidentity$get_principal_tag_attribute_map_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$get_principal_tag_attribute_map <- cognitoidentity_get_principal_tag_attribute_map

#' Lists the identities in an identity pool
#'
#' @description
#' Lists the identities in an identity pool.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/list_identities.html](https://paws-r.github.io/docs/cognitoidentity/list_identities.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param MaxResults &#91;required&#93; The maximum number of identities to return.
#' @param NextToken A pagination token.
#' @param HideDisabled An optional boolean parameter that allows you to hide disabled
#' identities. If omitted, the ListIdentities API will include disabled
#' identities in the response.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_list_identities
cognitoidentity_list_identities <- function(IdentityPoolId, MaxResults, NextToken = NULL, HideDisabled = NULL) {
  op <- new_operation(
    name = "ListIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$list_identities_input(IdentityPoolId = IdentityPoolId, MaxResults = MaxResults, NextToken = NextToken, HideDisabled = HideDisabled)
  output <- .cognitoidentity$list_identities_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$list_identities <- cognitoidentity_list_identities

#' Lists all of the Cognito identity pools registered for your account
#'
#' @description
#' Lists all of the Cognito identity pools registered for your account.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/list_identity_pools.html](https://paws-r.github.io/docs/cognitoidentity/list_identity_pools.html) for full documentation.
#'
#' @param MaxResults &#91;required&#93; The maximum number of identities to return.
#' @param NextToken A pagination token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_list_identity_pools
cognitoidentity_list_identity_pools <- function(MaxResults, NextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityPools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$list_identity_pools_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentity$list_identity_pools_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$list_identity_pools <- cognitoidentity_list_identity_pools

#' Lists the tags that are assigned to an Amazon Cognito identity pool
#'
#' @description
#' Lists the tags that are assigned to an Amazon Cognito identity pool.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/list_tags_for_resource.html](https://paws-r.github.io/docs/cognitoidentity/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the identity pool that the tags are
#' assigned to.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_list_tags_for_resource
cognitoidentity_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cognitoidentity$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$list_tags_for_resource <- cognitoidentity_list_tags_for_resource

#' Retrieves the IdentityID associated with a DeveloperUserIdentifier or
#' the list of DeveloperUserIdentifier values associated with an IdentityId
#' for an existing identity
#'
#' @description
#' Retrieves the `IdentityID` associated with a `DeveloperUserIdentifier` or the list of `DeveloperUserIdentifier` values associated with an `IdentityId` for an existing identity. Either `IdentityID` or `DeveloperUserIdentifier` must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, `DeveloperUserIdentifier` will be matched against `IdentityID`. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a `ResourceConflictException` is thrown.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/lookup_developer_identity.html](https://paws-r.github.io/docs/cognitoidentity/lookup_developer_identity.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param IdentityId A unique identifier in the format REGION:GUID.
#' @param DeveloperUserIdentifier A unique ID used by your backend authentication process to identify a
#' user. Typically, a developer identity provider would issue many
#' developer user identifiers, in keeping with the number of users.
#' @param MaxResults The maximum number of identities to return.
#' @param NextToken A pagination token. The first call you make will have `NextToken` set to
#' null. After that the service will return `NextToken` values as needed.
#' For example, let's say you make a request with `MaxResults` set to 10,
#' and there are 20 matches in the database. The service will return a
#' pagination token as a part of the response. This token can be used to
#' call the API again and get results starting from the 11th match.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_lookup_developer_identity
cognitoidentity_lookup_developer_identity <- function(IdentityPoolId, IdentityId = NULL, DeveloperUserIdentifier = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "LookupDeveloperIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$lookup_developer_identity_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DeveloperUserIdentifier = DeveloperUserIdentifier, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentity$lookup_developer_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$lookup_developer_identity <- cognitoidentity_lookup_developer_identity

#' Merges two users having different IdentityIds, existing in the same
#' identity pool, and identified by the same developer provider
#'
#' @description
#' Merges two users having different `IdentityId`s, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (`SourceUserIdentifier`) with the `IdentityId` of the `DestinationUserIdentifier`. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/merge_developer_identities.html](https://paws-r.github.io/docs/cognitoidentity/merge_developer_identities.html) for full documentation.
#'
#' @param SourceUserIdentifier &#91;required&#93; User identifier for the source user. The value should be a
#' `DeveloperUserIdentifier`.
#' @param DestinationUserIdentifier &#91;required&#93; User identifier for the destination user. The value should be a
#' `DeveloperUserIdentifier`.
#' @param DeveloperProviderName &#91;required&#93; The "domain" by which Cognito will refer to your users. This is a
#' (pseudo) domain name that you provide while creating an identity pool.
#' This name acts as a placeholder that allows your backend and the Cognito
#' service to communicate about the developer provider. For the
#' `DeveloperProviderName`, you can use letters as well as period (.),
#' underscore (_), and dash (-).
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_merge_developer_identities
cognitoidentity_merge_developer_identities <- function(SourceUserIdentifier, DestinationUserIdentifier, DeveloperProviderName, IdentityPoolId) {
  op <- new_operation(
    name = "MergeDeveloperIdentities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$merge_developer_identities_input(SourceUserIdentifier = SourceUserIdentifier, DestinationUserIdentifier = DestinationUserIdentifier, DeveloperProviderName = DeveloperProviderName, IdentityPoolId = IdentityPoolId)
  output <- .cognitoidentity$merge_developer_identities_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$merge_developer_identities <- cognitoidentity_merge_developer_identities

#' Sets the roles for an identity pool
#'
#' @description
#' Sets the roles for an identity pool. These roles are used when making calls to [`get_credentials_for_identity`][cognitoidentity_get_credentials_for_identity] action.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/set_identity_pool_roles.html](https://paws-r.github.io/docs/cognitoidentity/set_identity_pool_roles.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param Roles &#91;required&#93; The map of roles associated with this pool. For a given role, the key
#' will be either "authenticated" or "unauthenticated" and the value will
#' be the Role ARN.
#' @param RoleMappings How users for a specific identity provider are to mapped to roles. This
#' is a string to RoleMapping object map. The string identifies the
#' identity provider, for example, "graph.facebook.com" or
#' "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
#' 
#' Up to 25 rules can be specified per identity provider.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_set_identity_pool_roles
cognitoidentity_set_identity_pool_roles <- function(IdentityPoolId, Roles, RoleMappings = NULL) {
  op <- new_operation(
    name = "SetIdentityPoolRoles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$set_identity_pool_roles_input(IdentityPoolId = IdentityPoolId, Roles = Roles, RoleMappings = RoleMappings)
  output <- .cognitoidentity$set_identity_pool_roles_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$set_identity_pool_roles <- cognitoidentity_set_identity_pool_roles

#' You can use this operation to use default (username and clientID)
#' attribute or custom attribute mappings
#'
#' @description
#' You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/set_principal_tag_attribute_map.html](https://paws-r.github.io/docs/cognitoidentity/set_principal_tag_attribute_map.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; The ID of the Identity Pool you want to set attribute mappings for.
#' @param IdentityProviderName &#91;required&#93; The provider name you want to use for attribute mappings.
#' @param UseDefaults You can use this operation to use default (username and clientID)
#' attribute mappings.
#' @param PrincipalTags You can use this operation to add principal tags.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_set_principal_tag_attribute_map
cognitoidentity_set_principal_tag_attribute_map <- function(IdentityPoolId, IdentityProviderName, UseDefaults = NULL, PrincipalTags = NULL) {
  op <- new_operation(
    name = "SetPrincipalTagAttributeMap",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$set_principal_tag_attribute_map_input(IdentityPoolId = IdentityPoolId, IdentityProviderName = IdentityProviderName, UseDefaults = UseDefaults, PrincipalTags = PrincipalTags)
  output <- .cognitoidentity$set_principal_tag_attribute_map_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$set_principal_tag_attribute_map <- cognitoidentity_set_principal_tag_attribute_map

#' Assigns a set of tags to the specified Amazon Cognito identity pool
#'
#' @description
#' Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other criteria.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/tag_resource.html](https://paws-r.github.io/docs/cognitoidentity/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the identity pool.
#' @param Tags &#91;required&#93; The tags to assign to the identity pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_tag_resource
cognitoidentity_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cognitoidentity$tag_resource_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$tag_resource <- cognitoidentity_tag_resource

#' Unlinks a DeveloperUserIdentifier from an existing identity
#'
#' @description
#' Unlinks a `DeveloperUserIdentifier` from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/unlink_developer_identity.html](https://paws-r.github.io/docs/cognitoidentity/unlink_developer_identity.html) for full documentation.
#'
#' @param IdentityId &#91;required&#93; A unique identifier in the format REGION:GUID.
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param DeveloperProviderName &#91;required&#93; The "domain" by which Cognito will refer to your users.
#' @param DeveloperUserIdentifier &#91;required&#93; A unique ID used by your backend authentication process to identify a
#' user.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_unlink_developer_identity
cognitoidentity_unlink_developer_identity <- function(IdentityId, IdentityPoolId, DeveloperProviderName, DeveloperUserIdentifier) {
  op <- new_operation(
    name = "UnlinkDeveloperIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$unlink_developer_identity_input(IdentityId = IdentityId, IdentityPoolId = IdentityPoolId, DeveloperProviderName = DeveloperProviderName, DeveloperUserIdentifier = DeveloperUserIdentifier)
  output <- .cognitoidentity$unlink_developer_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$unlink_developer_identity <- cognitoidentity_unlink_developer_identity

#' Unlinks a federated identity from an existing account
#'
#' @description
#' Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/unlink_identity.html](https://paws-r.github.io/docs/cognitoidentity/unlink_identity.html) for full documentation.
#'
#' @param IdentityId &#91;required&#93; A unique identifier in the format REGION:GUID.
#' @param Logins &#91;required&#93; A set of optional name-value pairs that map provider names to provider
#' tokens.
#' @param LoginsToRemove &#91;required&#93; Provider names to unlink from this identity.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_unlink_identity
cognitoidentity_unlink_identity <- function(IdentityId, Logins, LoginsToRemove) {
  op <- new_operation(
    name = "UnlinkIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$unlink_identity_input(IdentityId = IdentityId, Logins = Logins, LoginsToRemove = LoginsToRemove)
  output <- .cognitoidentity$unlink_identity_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$unlink_identity <- cognitoidentity_unlink_identity

#' Removes the specified tags from the specified Amazon Cognito identity
#' pool
#'
#' @description
#' Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times per second, per account
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/untag_resource.html](https://paws-r.github.io/docs/cognitoidentity/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the identity pool.
#' @param TagKeys &#91;required&#93; The keys of the tags to remove from the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_untag_resource
cognitoidentity_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cognitoidentity$untag_resource_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$untag_resource <- cognitoidentity_untag_resource

#' Updates an identity pool
#'
#' @description
#' Updates an identity pool.
#'
#' See [https://paws-r.github.io/docs/cognitoidentity/update_identity_pool.html](https://paws-r.github.io/docs/cognitoidentity/update_identity_pool.html) for full documentation.
#'
#' @param IdentityPoolId &#91;required&#93; An identity pool ID in the format REGION:GUID.
#' @param IdentityPoolName &#91;required&#93; A string that you provide.
#' @param AllowUnauthenticatedIdentities &#91;required&#93; TRUE if the identity pool supports unauthenticated logins.
#' @param AllowClassicFlow Enables or disables the Basic (Classic) authentication flow. For more
#' information, see [Identity Pools (Federated Identities) Authentication
#' Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html)
#' in the *Amazon Cognito Developer Guide*.
#' @param SupportedLoginProviders Optional key:value pairs mapping provider names to provider app IDs.
#' @param DeveloperProviderName The "domain" by which Cognito will refer to your users.
#' @param OpenIdConnectProviderARNs The ARNs of the OpenID Connect providers.
#' @param CognitoIdentityProviders A list representing an Amazon Cognito user pool and its client ID.
#' @param SamlProviderARNs An array of Amazon Resource Names (ARNs) of the SAML provider for your
#' identity pool.
#' @param IdentityPoolTags The tags that are assigned to the identity pool. A tag is a label that
#' you can apply to identity pools to categorize and manage them in
#' different ways, such as by purpose, owner, environment, or other
#' criteria.
#'
#' @keywords internal
#'
#' @rdname cognitoidentity_update_identity_pool
cognitoidentity_update_identity_pool <- function(IdentityPoolId, IdentityPoolName, AllowUnauthenticatedIdentities, AllowClassicFlow = NULL, SupportedLoginProviders = NULL, DeveloperProviderName = NULL, OpenIdConnectProviderARNs = NULL, CognitoIdentityProviders = NULL, SamlProviderARNs = NULL, IdentityPoolTags = NULL) {
  op <- new_operation(
    name = "UpdateIdentityPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentity$update_identity_pool_input(IdentityPoolId = IdentityPoolId, IdentityPoolName = IdentityPoolName, AllowUnauthenticatedIdentities = AllowUnauthenticatedIdentities, AllowClassicFlow = AllowClassicFlow, SupportedLoginProviders = SupportedLoginProviders, DeveloperProviderName = DeveloperProviderName, OpenIdConnectProviderARNs = OpenIdConnectProviderARNs, CognitoIdentityProviders = CognitoIdentityProviders, SamlProviderARNs = SamlProviderARNs, IdentityPoolTags = IdentityPoolTags)
  output <- .cognitoidentity$update_identity_pool_output()
  config <- get_config()
  svc <- .cognitoidentity$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentity$operations$update_identity_pool <- cognitoidentity_update_identity_pool
