# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include account_service.R
NULL

#' Deletes the specified alternate contact from an Amazon Web Services
#' account
#'
#' @description
#' Deletes the specified alternate contact from an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/account/delete_alternate_contact.html](https://paws-r.github.io/docs/account/delete_alternate_contact.html) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which of the alternate contacts to delete.
#'
#' @keywords internal
#'
#' @rdname account_delete_alternate_contact
account_delete_alternate_contact <- function(AccountId = NULL, AlternateContactType) {
  op <- new_operation(
    name = "DeleteAlternateContact",
    http_method = "POST",
    http_path = "/deleteAlternateContact",
    paginator = list()
  )
  input <- .account$delete_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType)
  output <- .account$delete_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$delete_alternate_contact <- account_delete_alternate_contact

#' Retrieves the specified alternate contact attached to an Amazon Web
#' Services account
#'
#' @description
#' Retrieves the specified alternate contact attached to an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/account/get_alternate_contact.html](https://paws-r.github.io/docs/account/get_alternate_contact.html) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which alternate contact you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname account_get_alternate_contact
account_get_alternate_contact <- function(AccountId = NULL, AlternateContactType) {
  op <- new_operation(
    name = "GetAlternateContact",
    http_method = "POST",
    http_path = "/getAlternateContact",
    paginator = list()
  )
  input <- .account$get_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType)
  output <- .account$get_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_alternate_contact <- account_get_alternate_contact

#' Retrieves the primary contact information of an Amazon Web Services
#' account
#'
#' @description
#' Retrieves the primary contact information of an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/account/get_contact_information.html](https://paws-r.github.io/docs/account/get_contact_information.html) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must also
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#'
#' @keywords internal
#'
#' @rdname account_get_contact_information
account_get_contact_information <- function(AccountId = NULL) {
  op <- new_operation(
    name = "GetContactInformation",
    http_method = "POST",
    http_path = "/getContactInformation",
    paginator = list()
  )
  input <- .account$get_contact_information_input(AccountId = AccountId)
  output <- .account$get_contact_information_output()
  config <- get_config()
  svc <- .account$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_contact_information <- account_get_contact_information

#' Modifies the specified alternate contact attached to an Amazon Web
#' Services account
#'
#' @description
#' Modifies the specified alternate contact attached to an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/account/put_alternate_contact.html](https://paws-r.github.io/docs/account/put_alternate_contact.html) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which alternate contact you want to create or update.
#' @param EmailAddress &#91;required&#93; Specifies an email address for the alternate contact.
#' @param Name &#91;required&#93; Specifies a name for the alternate contact.
#' @param PhoneNumber &#91;required&#93; Specifies a phone number for the alternate contact.
#' @param Title &#91;required&#93; Specifies a title for the alternate contact.
#'
#' @keywords internal
#'
#' @rdname account_put_alternate_contact
account_put_alternate_contact <- function(AccountId = NULL, AlternateContactType, EmailAddress, Name, PhoneNumber, Title) {
  op <- new_operation(
    name = "PutAlternateContact",
    http_method = "POST",
    http_path = "/putAlternateContact",
    paginator = list()
  )
  input <- .account$put_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType, EmailAddress = EmailAddress, Name = Name, PhoneNumber = PhoneNumber, Title = Title)
  output <- .account$put_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$put_alternate_contact <- account_put_alternate_contact

#' Updates the primary contact information of an Amazon Web Services
#' account
#'
#' @description
#' Updates the primary contact information of an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/account/put_contact_information.html](https://paws-r.github.io/docs/account/put_contact_information.html) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must also
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param ContactInformation &#91;required&#93; Contains the details of the primary contact information associated with
#' an Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname account_put_contact_information
account_put_contact_information <- function(AccountId = NULL, ContactInformation) {
  op <- new_operation(
    name = "PutContactInformation",
    http_method = "POST",
    http_path = "/putContactInformation",
    paginator = list()
  )
  input <- .account$put_contact_information_input(AccountId = AccountId, ContactInformation = ContactInformation)
  output <- .account$put_contact_information_output()
  config <- get_config()
  svc <- .account$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$put_contact_information <- account_put_contact_information
