% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_rate_based_rule}
\alias{waf_delete_rate_based_rule}
\title{Permanently deletes a RateBasedRule}
\usage{
waf_delete_rate_based_rule(RuleId, ChangeToken)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the RateBasedRule that you want to delete. \code{RuleId} is
returned by CreateRateBasedRule and by ListRateBasedRules.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a RateBasedRule. You can\'t delete a rule if it\'s
still used in any \code{WebACL} objects or if it still includes any
predicates, such as \code{ByteMatchSet} objects.
}
\details{
If you just want to remove a rule from a \code{WebACL}, use UpdateWebACL.

To permanently delete a \code{RateBasedRule} from AWS WAF, perform the
following steps:
\enumerate{
\item Update the \code{RateBasedRule} to remove predicates, if any. For more
information, see UpdateRateBasedRule.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteRateBasedRule} request.
\item Submit a \code{DeleteRateBasedRule} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_rate_based_rule(
  RuleId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
