% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_get_secret_value}
\alias{secretsmanager_get_secret_value}
\title{Retrieves the contents of the encrypted fields SecretString or
SecretBinary from the specified version of a secret, whichever contains
content}
\usage{
secretsmanager_get_secret_value(SecretId, VersionId, VersionStage)
}
\arguments{
\item{SecretId}{[required] Specifies the secret containing the version that you want to retrieve.
You can specify either the Amazon Resource Name (ARN) or the friendly
name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}

\item{VersionId}{Specifies the unique identifier of the version of the secret that you
want to retrieve. If you specify this parameter then don\'t specify
\code{VersionStage}. If you don\'t specify either a \code{VersionStage} or
\code{VersionId} then the default is to perform the operation on the version
with the \code{VersionStage} value of \code{AWSCURRENT}.

This value is typically a
\href{https://wikipedia.org/wiki/Universally_unique_identifier}{UUID-type}
value with 32 hexadecimal digits.}

\item{VersionStage}{Specifies the secret version that you want to retrieve by the staging
label attached to the version.

Staging labels are used to keep track of different versions during the
rotation process. If you use this parameter then don\'t specify
\code{VersionId}. If you don\'t specify either a \code{VersionStage} or
\code{VersionId}, then the default is to perform the operation on the version
with the \code{VersionStage} value of \code{AWSCURRENT}.}
}
\description{
Retrieves the contents of the encrypted fields \code{SecretString} or
\code{SecretBinary} from the specified version of a secret, whichever
contains content.
}
\details{
\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:GetSecretValue
\item kms:Decrypt - required only if you use a customer-managed AWS KMS
key to encrypt the secret. You do not need this permission to use
the account\'s default AWS managed CMK for Secrets Manager.
}

\strong{Related operations}
\itemize{
\item To create a new version of the secret with different encrypted
information, use PutSecretValue.
\item To retrieve the non-encrypted details for the secret, use
DescribeSecret.
}
}
\section{Request syntax}{
\preformatted{svc$get_secret_value(
  SecretId = "string",
  VersionId = "string",
  VersionStage = "string"
)
}
}

\examples{
\dontrun{
# The following example shows how to retrieve the secret string value from
# the version of the secret that has the AWSPREVIOUS staging label
# attached. If you want to retrieve the AWSCURRENT version of the secret,
# then you can omit the VersionStage parameter because it defaults to
# AWSCURRENT.
svc$get_secret_value(
  SecretId = "MyTestDatabaseSecret",
  VersionStage = "AWSPREVIOUS"
)
}

}
\keyword{internal}
