% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_list_size_constraint_sets}
\alias{waf_list_size_constraint_sets}
\title{Returns an array of SizeConstraintSetSummary objects}
\usage{
waf_list_size_constraint_sets(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more
\code{SizeConstraintSets} than the value of \code{Limit}, AWS WAF returns a
\code{NextMarker} value in the response that allows you to list another group
of \code{SizeConstraintSets}. For the second and subsequent
\code{ListSizeConstraintSets} requests, specify the value of \code{NextMarker}
from the previous response to get information about another batch of
\code{SizeConstraintSets}.}

\item{Limit}{Specifies the number of \code{SizeConstraintSet} objects that you want AWS
WAF to return for this request. If you have more \code{SizeConstraintSets}
objects than the number you specify for \code{Limit}, the response includes a
\code{NextMarker} value that you can use to get another batch of
\code{SizeConstraintSet} objects.}
}
\description{
Returns an array of SizeConstraintSetSummary objects.
}
\section{Request syntax}{
\preformatted{svc$list_size_constraint_sets(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
# The following example returns an array of up to 100 size contraint match
# sets.
\dontrun{svc$list_size_constraint_sets(
  Limit = 100L
)}

}
\keyword{internal}
