% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_key_rotation_status}
\alias{kms_get_key_rotation_status}
\title{Gets a Boolean value that indicates whether automatic rotation of the
key material is enabled for the specified customer master key (CMK)}
\usage{
kms_get_key_rotation_status(KeyId)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
specify a CMK in a different AWS account, you must use the key ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}
}
\description{
Gets a Boolean value that indicates whether \href{https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html}{automatic rotation of the key material}
is enabled for the specified customer master key (CMK).
}
\details{
You cannot enable automatic rotation of asymmetric CMKs, CMKs with
imported key material, or CMKs in a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}.
The key rotation status for these CMKs is always \code{false}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
\itemize{
\item Disabled: The key rotation status does not change when you disable a
CMK. However, while the CMK is disabled, AWS KMS does not rotate the
backing key.
\item Pending deletion: While a CMK is pending deletion, its key rotation
status is \code{false} and AWS KMS does not rotate the backing key. If
you cancel the deletion, the original key rotation status is
restored.
}

To perform this operation on a CMK in a different AWS account, specify
the key ARN in the value of the \code{KeyId} parameter.
}
\section{Request syntax}{
\preformatted{svc$get_key_rotation_status(
  KeyId = "string"
)
}
}

\examples{
# The following example retrieves the status of automatic annual rotation
# of the key material for the specified CMK.
\dontrun{svc$get_key_rotation_status(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
