% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_object_parent_paths}
\alias{clouddirectory_list_object_parent_paths}
\title{Retrieves all available parent paths for any object type such as node,
leaf node, policy node, and index node objects}
\usage{
clouddirectory_list_object_parent_paths(DirectoryArn, ObjectReference,
  NextToken, MaxResults)
}
\arguments{
\item{DirectoryArn}{[required] The ARN of the directory to which the parent path applies.}

\item{ObjectReference}{[required] The reference that identifies the object whose parent paths are listed.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of items to be retrieved in a single call. This is an
approximate number.}
}
\description{
Retrieves all available parent paths for any object type such as node,
leaf node, policy node, and index node objects. For more information
about objects, see \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html}{Directory Structure}.
}
\details{
Use this API to evaluate all parents for an object. The call returns all
objects from the root of the directory up to the requested object. The
API returns the number of paths based on user-defined \code{MaxResults}, in
case there are multiple paths to the parent. The order of the paths and
nodes returned is consistent among multiple API calls unless the objects
are deleted or moved. Paths not leading to the directory root are
ignored from the target object.
}
\section{Request syntax}{
\preformatted{svc$list_object_parent_paths(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
