% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_get_certificate}
\alias{acm_get_certificate}
\title{Retrieves a certificate specified by an ARN and its certificate chain}
\usage{
acm_get_certificate(CertificateArn)
}
\arguments{
\item{CertificateArn}{[required] String that contains a certificate ARN in the following format:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}
}
\description{
Retrieves a certificate specified by an ARN and its certificate chain .
The chain is an ordered list of certificates that contains the end
entity certificate, intermediate certificates of subordinate CAs, and
the root certificate in that order. The certificate and certificate
chain are base64 encoded. If you want to decode the certificate to see
the individual fields, you can use OpenSSL.
}
\section{Request syntax}{
\preformatted{svc$get_certificate(
  CertificateArn = "string"
)
}
}

\keyword{internal}
