% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_sign_up}
\alias{cognitoidentityprovider_sign_up}
\title{Registers the user in the specified user pool and creates a user name,
password, and user attributes}
\usage{
cognitoidentityprovider_sign_up(ClientId, SecretHash, Username,
  Password, UserAttributes, ValidationData, AnalyticsMetadata,
  UserContextData, ClientMetadata)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user you wish to register.}

\item{Password}{[required] The password of the user you wish to register.}

\item{UserAttributes}{An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \verb{custom:} prefix to the
attribute name.}

\item{ValidationData}{The validation data in the request to register a user.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{SignUp} calls.}

\item{UserContextData}{Contextual data such as the user\'s device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the SignUp API action, Amazon Cognito
invokes any functions that are assigned to the following triggers: \emph{pre
sign-up}, \emph{custom message}, and \emph{post confirmation}. When Amazon Cognito
invokes any of these functions, it passes a JSON payload, which the
function receives as input. This payload contains a \code{clientMetadata}
attribute, which provides the data that you assigned to the
ClientMetadata parameter in your SignUp request. In your function code
in AWS Lambda, you can process the \code{clientMetadata} value to enhance
your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don\'t use it to provide sensitive information.
}}
}
\description{
Registers the user in the specified user pool and creates a user name,
password, and user attributes.
}
\section{Request syntax}{
\preformatted{svc$sign_up(
  ClientId = "string",
  SecretHash = "string",
  Username = "string",
  Password = "string",
  UserAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ValidationData = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  ),
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
