% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_principals}
\alias{ram_list_principals}
\title{Lists the principals with access to the specified resource}
\usage{
ram_list_principals(resourceOwner, resourceArn, principals,
  resourceType, resourceShareArns, nextToken, maxResults)
}
\arguments{
\item{resourceOwner}{[required] The type of owner.}

\item{resourceArn}{The Amazon Resource Name (ARN) of the resource.}

\item{principals}{The principals.}

\item{resourceType}{The resource type.}

\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Lists the principals with access to the specified resource.
}
\section{Request syntax}{
\preformatted{svc$list_principals(
  resourceOwner = "SELF"|"OTHER-ACCOUNTS",
  resourceArn = "string",
  principals = list(
    "string"
  ),
  resourceType = "string",
  resourceShareArns = list(
    "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
