% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_untag_certificate_authority}
\alias{acmpca_untag_certificate_authority}
\title{Remove one or more tags from your private CA}
\usage{
acmpca_untag_certificate_authority(CertificateAuthorityArn, Tags)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }}

\item{Tags}{[required] List of tags to be removed from the CA.}
}
\description{
Remove one or more tags from your private CA. A tag consists of a
key-value pair. If you do not specify the value portion of the tag when
calling this action, the tag will be removed regardless of value. If you
specify a value, the tag is removed only if it is associated with the
specified value. To add tags to a private CA, use the
TagCertificateAuthority. Call the ListTags action to see what tags are
associated with your CA.
}
\section{Request syntax}{
\preformatted{svc$untag_certificate_authority(
  CertificateAuthorityArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
