# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS CloudHSM V2
#'
#' @description
#' For more information about AWS CloudHSM, see [AWS
#' CloudHSM](http://aws.amazon.com/cloudhsm/) and the [AWS CloudHSM User
#' Guide](http://docs.aws.amazon.com/cloudhsm/latest/userguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudhsmv2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- cloudhsmv2()
#' svc$copy_backup_to_region(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudhsmv2_copy_backup_to_region]{copy_backup_to_region} \tab Copy an AWS CloudHSM cluster backup to a different region \cr
#'  \link[=cloudhsmv2_create_cluster]{create_cluster} \tab Creates a new AWS CloudHSM cluster \cr
#'  \link[=cloudhsmv2_create_hsm]{create_hsm} \tab Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster \cr
#'  \link[=cloudhsmv2_delete_backup]{delete_backup} \tab Deletes a specified AWS CloudHSM backup \cr
#'  \link[=cloudhsmv2_delete_cluster]{delete_cluster} \tab Deletes the specified AWS CloudHSM cluster \cr
#'  \link[=cloudhsmv2_delete_hsm]{delete_hsm} \tab Deletes the specified HSM \cr
#'  \link[=cloudhsmv2_describe_backups]{describe_backups} \tab Gets information about backups of AWS CloudHSM clusters \cr
#'  \link[=cloudhsmv2_describe_clusters]{describe_clusters} \tab Gets information about AWS CloudHSM clusters \cr
#'  \link[=cloudhsmv2_initialize_cluster]{initialize_cluster} \tab Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate\cr
#'  \link[=cloudhsmv2_list_tags]{list_tags} \tab Gets a list of tags for the specified AWS CloudHSM cluster \cr
#'  \link[=cloudhsmv2_restore_backup]{restore_backup} \tab Restores a specified AWS CloudHSM backup that is in the PENDING_DELETION state \cr
#'  \link[=cloudhsmv2_tag_resource]{tag_resource} \tab Adds or overwrites one or more tags for the specified AWS CloudHSM cluster \cr
#'  \link[=cloudhsmv2_untag_resource]{untag_resource} \tab Removes the specified tag or tags from the specified AWS CloudHSM cluster 
#' }
#'
#' @rdname cloudhsmv2
#' @export
cloudhsmv2 <- function(config = list()) {
  svc <- .cloudhsmv2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudhsmv2 <- list()

.cloudhsmv2$operations <- list()

.cloudhsmv2$metadata <- list(
  service_name = "cloudhsmv2",
  endpoints = list("*" = list(endpoint = "cloudhsmv2.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudhsmv2.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "CloudHSM V2",
  api_version = "2017-04-28",
  signing_name = "cloudhsm",
  json_version = "1.1",
  target_prefix = "BaldrApiService"
)

.cloudhsmv2$handlers <- new_handlers("jsonrpc", "v4")

.cloudhsmv2$service <- function(config = list()) {
  new_service(.cloudhsmv2$metadata, .cloudhsmv2$handlers, config)
}
