% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_update_insight}
\alias{securityhub_update_insight}
\title{Updates the Security Hub insight that the insight ARN specifies}
\usage{
securityhub_update_insight(InsightArn, Name, Filters, GroupByAttribute)
}
\arguments{
\item{InsightArn}{[required] The ARN of the insight that you want to update.}

\item{Name}{The updated name for the insight.}

\item{Filters}{The updated filters that define this insight.}

\item{GroupByAttribute}{The updated \code{GroupBy} attribute that defines this insight.}
}
\description{
Updates the Security Hub insight that the insight ARN specifies.
}
\section{Request syntax}{
\preformatted{svc$update_insight(
  InsightArn = "string",
  Name = "string",
  Filters = list(
    ProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    AwsAccountId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    Id = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    GeneratorId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    Type = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    FirstObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    LastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    CreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    UpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    SeverityProduct = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityNormalized = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityLabel = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    Confidence = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Criticality = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Title = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    Description = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    RecommendationText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    SourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ProductFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"
      )
    ),
    ProductName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    CompanyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    UserDefinedFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"
      )
    ),
    MalwareName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    MalwareType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    MalwarePath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    MalwareState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NetworkDirection = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NetworkProtocol = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NetworkSourceIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourceIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourcePort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkSourceDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NetworkSourceMac = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NetworkDestinationIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationPort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkDestinationDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ProcessName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ProcessPath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ProcessPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessParentPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ProcessTerminatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorValue = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorCategory = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorLastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorSource = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorSourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourcePartition = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceRegion = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceTags = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"
      )
    ),
    ResourceAwsEc2InstanceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceIpV4Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceIpV6Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceKeyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceIamInstanceProfileArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceVpcId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceSubnetId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceAwsS3BucketOwnerId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsS3BucketOwnerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyUserName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyCreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceContainerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceContainerImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceContainerImageName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    ResourceContainerLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceDetailsOther = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"
      )
    ),
    ComplianceStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    VerificationState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    WorkflowState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    RecordState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    RelatedFindingsProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    RelatedFindingsId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NoteText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    NoteUpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    NoteUpdatedBy = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"
      )
    ),
    Keyword = list(
      list(
        Value = "string"
      )
    )
  ),
  GroupByAttribute = "string"
)
}
}

\keyword{internal}
