% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_import_key_material}
\alias{kms_import_key_material}
\title{Imports key material into an existing AWS KMS customer master key (CMK)
that was created without key material}
\usage{
kms_import_key_material(KeyId, ImportToken, EncryptedKeyMaterial,
  ValidTo, ExpirationModel)
}
\arguments{
\item{KeyId}{[required] The identifier of the CMK to import the key material into. The CMK's
\code{Origin} must be \code{EXTERNAL}.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{ImportToken}{[required] The import token that you received in the response to a previous
GetParametersForImport request. It must be from the same response that
contained the public key that you used to encrypt the key material.}

\item{EncryptedKeyMaterial}{[required] The encrypted key material to import. It must be encrypted with the
public key that you received in the response to a previous
GetParametersForImport request, using the wrapping algorithm that you
specified in that request.}

\item{ValidTo}{The time at which the imported key material expires. When the key
material expires, AWS KMS deletes the key material and the CMK becomes
unusable. You must omit this parameter when the \code{ExpirationModel}
parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE}. Otherwise it is
required.}

\item{ExpirationModel}{Specifies whether the key material expires. The default is
\code{KEY_MATERIAL_EXPIRES}, in which case you must include the \code{ValidTo}
parameter. When this parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE},
you must omit the \code{ValidTo} parameter.}
}
\description{
Imports key material into an existing AWS KMS customer master key (CMK)
that was created without key material. You cannot perform this operation
on a CMK in a different AWS account. For more information about creating
CMKs with no key material and then importing key material, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing Key Material}
in the \emph{AWS Key Management Service Developer Guide}.
}
\details{
Before using this operation, call GetParametersForImport. Its response
includes a public key and an import token. Use the public key to encrypt
the key material. Then, submit the import token from the same
\code{GetParametersForImport} response.

When calling this operation, you must specify the following values:
\itemize{
\item The key ID or key ARN of a CMK with no key material. Its \code{Origin}
must be \code{EXTERNAL}.
}

To create a CMK with no key material, call CreateKey and set the
value of its \code{Origin} parameter to \code{EXTERNAL}. To get the \code{Origin}
of a CMK, call DescribeKey.)
\itemize{
\item The encrypted key material. To get the public key to encrypt the key
material, call GetParametersForImport.
\item The import token that GetParametersForImport returned. This token
and the public key used to encrypt the key material must have come
from the same response.
\item Whether the key material expires and if so, when. If you set an
expiration date, you can change it only by reimporting the same key
material and specifying a new expiration date. If the key material
expires, AWS KMS deletes the key material and the CMK becomes
unusable. To use the CMK again, you must reimport the same key
material.
}

When this operation is successful, the key state of the CMK changes from
\code{PendingImport} to \code{Enabled}, and you can use the CMK. After you
successfully import key material into a CMK, you can reimport the same
key material into that CMK, but you cannot import different key
material.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$import_key_material(
  KeyId = "string",
  ImportToken = raw,
  EncryptedKeyMaterial = raw,
  ValidTo = as.POSIXct(
    "2015-01-01"
  ),
  ExpirationModel = "KEY_MATERIAL_EXPIRES"|"KEY_MATERIAL_DOES_NOT_EXPIRE"
)
}
}

\examples{
# The following example imports key material into the specified CMK.
\donttest{svc$import_key_material(
  EncryptedKeyMaterial = "<binary data>",
  ExpirationModel = "KEY_MATERIAL_DOES_NOT_EXPIRE",
  ImportToken = "<binary data>",
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
