% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_forgot_password}
\alias{cognitoidentityprovider_forgot_password}
\title{Calling this API causes a message to be sent to the end user with a
confirmation code that is required to change the user's password}
\usage{
cognitoidentityprovider_forgot_password(ClientId, SecretHash,
  UserContextData, Username, AnalyticsMetadata)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}

\item{Username}{[required] The user name of the user for whom you want to enter a code to reset a
forgotten password.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{ForgotPassword} calls.}
}
\description{
Calling this API causes a message to be sent to the end user with a
confirmation code that is required to change the user's password. For
the \code{Username} parameter, you can use the username or user alias. If a
verified phone number exists for the user, the confirmation code is sent
to the phone number. Otherwise, if a verified email exists, the
confirmation code is sent to the email. If neither a verified phone
number nor a verified email exists, \code{InvalidParameterException} is
thrown. To use the confirmation code for resetting the password, call .
}
\section{Request syntax}{
\preformatted{svc$forgot_password(
  ClientId = "string",
  SecretHash = "string",
  UserContextData = list(
    EncodedData = "string"
  ),
  Username = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  )
)
}
}

\keyword{internal}
