% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_rule_group}
\alias{waf_delete_rule_group}
\title{This is AWS WAF Classic documentation}
\usage{
waf_delete_rule_group(RuleGroupId, ChangeToken)
}
\arguments{
\item{RuleGroupId}{[required] The \code{RuleGroupId} of the RuleGroup that you want to delete.
\code{RuleGroupId} is returned by
\code{\link[=waf_create_rule_group]{create_rule_group}} and by
\code{\link[=waf_list_rule_groups]{list_rule_groups}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=waf_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a RuleGroup. You can't delete a \code{RuleGroup} if it's
still used in any \code{WebACL} objects or if it still includes any rules.

If you just want to remove a \code{RuleGroup} from a \code{WebACL}, use
\code{\link[=waf_update_web_acl]{update_web_acl}}.

To permanently delete a \code{RuleGroup} from AWS WAF, perform the following
steps:
\enumerate{
\item Update the \code{RuleGroup} to remove rules, if any. For more
information, see \code{\link[=waf_update_rule_group]{update_rule_group}}.
\item Use \code{\link[=waf_get_change_token]{get_change_token}} to get the change
token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=waf_delete_rule_group]{delete_rule_group}} request.
\item Submit a \code{\link[=waf_delete_rule_group]{delete_rule_group}} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_rule_group(
  RuleGroupId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
