% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_create_cluster}
\alias{cloudhsmv2_create_cluster}
\title{Creates a new AWS CloudHSM cluster}
\usage{
cloudhsmv2_create_cluster(BackupRetentionPolicy, HsmType,
  SourceBackupId, SubnetIds, TagList)
}
\arguments{
\item{BackupRetentionPolicy}{A policy that defines how the service retains backups.}

\item{HsmType}{[required] The type of HSM to use in the cluster. Currently the only allowed value
is \code{hsm1.medium}.}

\item{SourceBackupId}{The identifier (ID) of the cluster backup to restore. Use this value to
restore the cluster from a backup instead of creating a new cluster. To
find the backup ID, use
\code{\link[=cloudhsmv2_describe_backups]{describe_backups}}.}

\item{SubnetIds}{[required] The identifiers (IDs) of the subnets where you are creating the cluster.
You must specify at least one subnet. If you specify multiple subnets,
they must meet the following criteria:
\itemize{
\item All subnets must be in the same virtual private cloud (VPC).
\item You can specify only one subnet per Availability Zone.
}}

\item{TagList}{Tags to apply to the CloudHSM cluster during creation.}
}
\value{
A list with the following syntax:\preformatted{list(
  Cluster = list(
    BackupPolicy = "DEFAULT",
    BackupRetentionPolicy = list(
      Type = "DAYS",
      Value = "string"
    ),
    ClusterId = "string",
    CreateTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Hsms = list(
      list(
        AvailabilityZone = "string",
        ClusterId = "string",
        SubnetId = "string",
        EniId = "string",
        EniIp = "string",
        HsmId = "string",
        State = "CREATE_IN_PROGRESS"|"ACTIVE"|"DEGRADED"|"DELETE_IN_PROGRESS"|"DELETED",
        StateMessage = "string"
      )
    ),
    HsmType = "string",
    PreCoPassword = "string",
    SecurityGroup = "string",
    SourceBackupId = "string",
    State = "CREATE_IN_PROGRESS"|"UNINITIALIZED"|"INITIALIZE_IN_PROGRESS"|"INITIALIZED"|"ACTIVE"|"UPDATE_IN_PROGRESS"|"DELETE_IN_PROGRESS"|"DELETED"|"DEGRADED",
    StateMessage = "string",
    SubnetMapping = list(
      "string"
    ),
    VpcId = "string",
    Certificates = list(
      ClusterCsr = "string",
      HsmCertificate = "string",
      AwsHardwareCertificate = "string",
      ManufacturerHardwareCertificate = "string",
      ClusterCertificate = "string"
    ),
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Creates a new AWS CloudHSM cluster.
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  BackupRetentionPolicy = list(
    Type = "DAYS",
    Value = "string"
  ),
  HsmType = "string",
  SourceBackupId = "string",
  SubnetIds = list(
    "string"
  ),
  TagList = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
