% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_describe_exclusions}
\alias{inspector_describe_exclusions}
\title{Describes the exclusions that are specified by the exclusions' ARNs}
\usage{
inspector_describe_exclusions(exclusionArns, locale)
}
\arguments{
\item{exclusionArns}{[required] The list of ARNs that specify the exclusions that you want to describe.}

\item{locale}{The locale into which you want to translate the exclusion's title,
description, and recommendation.}
}
\value{
A list with the following syntax:\preformatted{list(
  exclusions = list(
    list(
      arn = "string",
      title = "string",
      description = "string",
      recommendation = "string",
      scopes = list(
        list(
          key = "INSTANCE_ID"|"RULES_PACKAGE_ARN",
          value = "string"
        )
      ),
      attributes = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  ),
  failedItems = list(
    list(
      failureCode = "INVALID_ARN"|"DUPLICATE_ARN"|"ITEM_DOES_NOT_EXIST"|"ACCESS_DENIED"|"LIMIT_EXCEEDED"|"INTERNAL_ERROR",
      retryable = TRUE|FALSE
    )
  )
)
}
}
\description{
Describes the exclusions that are specified by the exclusions' ARNs.
}
\section{Request syntax}{
\preformatted{svc$describe_exclusions(
  exclusionArns = list(
    "string"
  ),
  locale = "EN_US"
)
}
}

\keyword{internal}
