% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_forgot_password}
\alias{cognitoidentityprovider_forgot_password}
\title{Calling this API causes a message to be sent to the end user with a
confirmation code that is required to change the user's password}
\usage{
cognitoidentityprovider_forgot_password(ClientId, SecretHash,
  UserContextData, Username, AnalyticsMetadata, ClientMetadata)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}

\item{Username}{[required] The user name of the user for whom you want to enter a code to reset a
forgotten password.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{\link[=cognitoidentityprovider_forgot_password]{forgot_password}} calls.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the ForgotPassword API action, Amazon
Cognito invokes any functions that are assigned to the following
triggers: \emph{pre sign-up}, \emph{custom message}, and \emph{user migration}. When
Amazon Cognito invokes any of these functions, it passes a JSON payload,
which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your ForgotPassword request. In your
function code in AWS Lambda, you can process the \code{clientMetadata} value
to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  CodeDeliveryDetails = list(
    Destination = "string",
    DeliveryMedium = "SMS"|"EMAIL",
    AttributeName = "string"
  )
)
}
}
\description{
Calling this API causes a message to be sent to the end user with a
confirmation code that is required to change the user's password. For
the \code{Username} parameter, you can use the username or user alias. The
method used to send the confirmation code is sent according to the
specified AccountRecoverySetting. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html}{Recovering User Accounts}
in the \emph{Amazon Cognito Developer Guide}. If neither a verified phone
number nor a verified email exists, an \code{InvalidParameterException} is
thrown. To use the confirmation code for resetting the password, call
\code{\link[=cognitoidentityprovider_confirm_forgot_password]{confirm_forgot_password}}.
}
\section{Request syntax}{
\preformatted{svc$forgot_password(
  ClientId = "string",
  SecretHash = "string",
  UserContextData = list(
    EncodedData = "string"
  ),
  Username = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
