% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_resource_server}
\alias{cognitoidentityprovider_create_resource_server}
\title{Creates a new OAuth2}
\usage{
cognitoidentityprovider_create_resource_server(UserPoolId, Identifier,
  Name, Scopes)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{Identifier}{[required] A unique resource server identifier for the resource server. This could
be an HTTPS endpoint where the resource server is located. For example,
\verb{https://my-weather-api.example.com}.}

\item{Name}{[required] A friendly name for the resource server.}

\item{Scopes}{A list of scopes. Each scope is map, where the keys are \code{name} and
\code{description}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResourceServer = list(
    UserPoolId = "string",
    Identifier = "string",
    Name = "string",
    Scopes = list(
      list(
        ScopeName = "string",
        ScopeDescription = "string"
      )
    )
  )
)
}
}
\description{
Creates a new OAuth2.0 resource server and defines custom scopes in it.
}
\section{Request syntax}{
\preformatted{svc$create_resource_server(
  UserPoolId = "string",
  Identifier = "string",
  Name = "string",
  Scopes = list(
    list(
      ScopeName = "string",
      ScopeDescription = "string"
    )
  )
)
}
}

\keyword{internal}
