% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_set_user_settings}
\alias{cognitoidentityprovider_admin_set_user_settings}
\title{Sets all the user settings for a specified user name}
\usage{
cognitoidentityprovider_admin_set_user_settings(UserPoolId, Username,
  MFAOptions)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to set the user's
settings, such as MFA options.}

\item{Username}{[required] The user name of the user for whom you wish to set user settings.}

\item{MFAOptions}{[required] Specifies the options for MFA (e.g., email or phone number).}
}
\description{
Sets all the user settings for a specified user name. Works on any user.
}
\details{
Requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_set_user_settings(
  UserPoolId = "string",
  Username = "string",
  MFAOptions = list(
    list(
      DeliveryMedium = "SMS"|"EMAIL",
      AttributeName = "string"
    )
  )
)
}
}

\keyword{internal}
