% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_permission}
\alias{acmpca_create_permission}
\title{Assigns permissions from a private CA to a designated AWS service}
\usage{
acmpca_create_permission(CertificateAuthorityArn, Principal,
  SourceAccount, Actions)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the CA that grants the permissions.
You can find the ARN by calling the ListCertificateAuthorities
operation. This must have the following form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{Principal}{[required] The AWS service or identity that receives the permission. At this time,
the only valid principal is \code{acm.amazonaws.com}.}

\item{SourceAccount}{The ID of the calling account.}

\item{Actions}{[required] The actions that the specified AWS service principal can use. These
include \code{IssueCertificate}, \code{GetCertificate}, and \code{ListPermissions}.}
}
\description{
Assigns permissions from a private CA to a designated AWS service.
Services are specified by their service principals and can be given
permission to create and retrieve certificates on a private CA. Services
can also be given permission to list the active permissions that the
private CA has granted. For ACM to automatically renew your private
CA's certificates, you must assign all possible permissions from the CA
to the ACM service principal.
}
\details{
At this time, you can only assign permissions to ACM
(\code{acm.amazonaws.com}). Permissions can be revoked with the
DeletePermission operation and listed with the ListPermissions
operation.
}
\section{Request syntax}{
\preformatted{svc$create_permission(
  CertificateAuthorityArn = "string",
  Principal = "string",
  SourceAccount = "string",
  Actions = list(
    "IssueCertificate"|"GetCertificate"|"ListPermissions"
  )
)
}
}

\keyword{internal}
