% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_data_deletion_jobs}
\alias{personalize_list_data_deletion_jobs}
\title{Returns a list of data deletion jobs for a dataset group ordered by
creation time, with the most recent first}
\usage{
personalize_list_data_deletion_jobs(
  datasetGroupArn = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{datasetGroupArn}{The Amazon Resource Name (ARN) of the dataset group to list data
deletion jobs for.}

\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_data_deletion_jobs]{list_data_deletion_jobs}} for
getting the next set of jobs (if they exist).}

\item{maxResults}{The maximum number of data deletion jobs to return.}
}
\description{
Returns a list of data deletion jobs for a dataset group ordered by creation time, with the most recent first. When a dataset group is not specified, all the data deletion jobs associated with the account are listed. The response provides the properties for each job, including the Amazon Resource Name (ARN). For more information on data deletion jobs, see \href{https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html}{Deleting users}.

See \url{https://www.paws-r-sdk.com/docs/personalize_list_data_deletion_jobs/} for full documentation.
}
\keyword{internal}
