% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagentruntime_operations.R
\name{bedrockagentruntime_invoke_inline_agent}
\alias{bedrockagentruntime_invoke_inline_agent}
\title{Invokes an inline Amazon Bedrock agent using the configurations you
provide with the request}
\usage{
bedrockagentruntime_invoke_inline_agent(
  actionGroups = NULL,
  bedrockModelConfigurations = NULL,
  customerEncryptionKeyArn = NULL,
  enableTrace = NULL,
  endSession = NULL,
  foundationModel,
  guardrailConfiguration = NULL,
  idleSessionTTLInSeconds = NULL,
  inlineSessionState = NULL,
  inputText = NULL,
  instruction,
  knowledgeBases = NULL,
  promptOverrideConfiguration = NULL,
  sessionId,
  streamingConfigurations = NULL
)
}
\arguments{
\item{actionGroups}{A list of action groups with each action group defining the action the
inline agent needs to carry out.}

\item{bedrockModelConfigurations}{Model settings for the request.}

\item{customerEncryptionKeyArn}{The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use
to encrypt your inline agent.}

\item{enableTrace}{Specifies whether to turn on the trace or not to track the agent's
reasoning process. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html}{Using trace}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ </p>
}\if{html}{\out{</div>}}}

\item{endSession}{Specifies whether to end the session with the inline agent or not.}

\item{foundationModel}{[required] The \href{https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns}{model identifier (ID)}
of the model to use for orchestration by the inline agent. For example,
\verb{meta.llama3-1-70b-instruct-v1:0}.}

\item{guardrailConfiguration}{The
\href{https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html}{guardrails}
to assign to the inline agent.}

\item{idleSessionTTLInSeconds}{The number of seconds for which the inline agent should maintain session
information. After this time expires, the subsequent
\code{\link[=bedrockagentruntime_invoke_inline_agent]{invoke_inline_agent}} request
begins a new session.

A user interaction remains active for the amount of time specified. If
no conversation occurs during this time, the session expires and the
data provided before the timeout is deleted.}

\item{inlineSessionState}{Parameters that specify the various attributes of a sessions. You can
include attributes for the session or prompt or, if you configured an
action group to return control, results from invocation of the action
group. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html}{Control session context}.

If you include \code{returnControlInvocationResults} in the \code{sessionState}
field, the \code{inputText} field will be ignored.}

\item{inputText}{The prompt text to send to the agent.

If you include \code{returnControlInvocationResults} in the \code{sessionState}
field, the \code{inputText} field will be ignored.}

\item{instruction}{[required] The instructions that tell the inline agent what it should do and how it
should interact with users.}

\item{knowledgeBases}{Contains information of the knowledge bases to associate with.}

\item{promptOverrideConfiguration}{Configurations for advanced prompts used to override the default prompts
to enhance the accuracy of the inline agent.}

\item{sessionId}{[required] The unique identifier of the session. Use the same value across requests
to continue the same conversation.}

\item{streamingConfigurations}{Specifies the configurations for streaming.

To use agent streaming, you need permissions to perform the
\code{bedrock:InvokeModelWithResponseStream} action.}
}
\description{
Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.

See \url{https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_inline_agent/} for full documentation.
}
\keyword{internal}
